/**
 * Copyright (C) 2011-2015 The XDocReport Team <xdocreport@googlegroups.com>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free  of charge, to any person obtaining
 * a  copy  of this  software  and  associated  documentation files  (the
 * "Software"), to  deal in  the Software without  restriction, including
 * without limitation  the rights to  use, copy, modify,  merge, publish,
 * distribute,  sublicense, and/or sell  copies of  the Software,  and to
 * permit persons to whom the Software  is furnished to do so, subject to
 * the following conditions:
 *
 * The  above  copyright  notice  and  this permission  notice  shall  be
 * included in all copies or substantial portions of the Software.
 *
 * THE  SOFTWARE IS  PROVIDED  "AS  IS", WITHOUT  WARRANTY  OF ANY  KIND,
 * EXPRESS OR  IMPLIED, INCLUDING  BUT NOT LIMITED  TO THE  WARRANTIES OF
 * MERCHANTABILITY,    FITNESS    FOR    A   PARTICULAR    PURPOSE    AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE,  ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package fr.opensagres.poi.xwpf.converter.xhtml.internal;

public class XHTMLConstants
{

    // XML type
    public static final String CDATA_TYPE = "CDATA";

    // HTML elements name
    public static final String HTML_ELEMENT = "html";

    public static final String HEAD_ELEMENT = "head";

    public static final String BODY_ELEMENT = "body";

    public static final String STYLE_ELEMENT = "style";

    public static final String TABLE_ELEMENT = "table";

    public static final String TR_ELEMENT = "tr";

    public static final String TH_ELEMENT = "th";

    public static final String TD_ELEMENT = "td";

    public static final String P_ELEMENT = "p";

    public static final String BR_ELEMENT = "br";

    public static final String DIV_ELEMENT = "div";

    public static final String PRE_ELEMENT = "pre";

    public static final String SPAN_ELEMENT = "span";

    public static final String IMG_ELEMENT = "img";

    public static final String A_ELEMENT = "a";

    // Attributes
    public static final String ID_ATTR = "id";
    
    public static final String CLASS_ATTR = "class";

    public static final String STYLE_ATTR = "style";

    public static final String SRC_ATTR = "src";

    public static final String COLSPAN_ATTR = "colspan";

    public static final String ROWSPAN_ATTR = "rowspan";

    public static final String HREF_ATTR = "href";

    // Entity

    public static final String SPACE_ENTITY = "&#32;";
}
