/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.docx.preprocessor.sax.notes;

import fr.opensagres.xdocreport.core.utils.XMLUtils;
import fr.opensagres.xdocreport.document.docx.DocxUtils;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.DocXBufferedDocumentContentHandler;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.DocxBufferedDocument;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.FldSimpleBufferedRegion;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.PBufferedRegion;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.notes.AbstractNoteBufferedRegion;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedElement;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractNotesBufferedDocument
extends DocxBufferedDocument {
    private AbstractNoteBufferedRegion currentNoteRegion;

    public AbstractNotesBufferedDocument(DocXBufferedDocumentContentHandler handler) {
        super(handler);
    }

    @Override
    protected BufferedElement createElement(BufferedElement parent, String uri, String localName, String name, Attributes attributes) throws SAXException {
        int idIndex;
        if (this.isNote(uri, localName, name) && (idIndex = attributes.getIndex("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "id")) != -1) {
            String attrName = attributes.getQName(idIndex);
            AttributesImpl attributesImpl = XMLUtils.toAttributesImpl((Attributes)attributes);
            attributesImpl.removeAttribute(idIndex);
            String id = attributes.getValue(idIndex);
            this.currentNoteRegion = this.createNoteBufferedRegion(uri, localName, name, attributesImpl);
            this.currentNoteRegion.setId(attrName, id);
            this.currentNoteRegion.setType(attributes.getValue("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "type"));
            return this.currentNoteRegion;
        }
        return super.createElement(parent, uri, localName, name, attributes);
    }

    @Override
    public void onEndEndElement(String uri, String localName, String name) {
        if (this.currentNoteRegion != null) {
            if (DocxUtils.isFldSimple(uri, localName, name) && this.getCurrentFldSimpleRegion() != null) {
                FldSimpleBufferedRegion fdldSimpleRegion = this.getCurrentFldSimpleRegion();
                super.onEndEndElement(uri, localName, name);
                if (fdldSimpleRegion.getName() != null && !fdldSimpleRegion.isReseted()) {
                    this.currentNoteRegion.setContainsField(true);
                }
                return;
            }
            if (DocxUtils.isP(uri, localName, name) && this.getCurrentPRegion() != null) {
                PBufferedRegion pRegion = this.getCurrentPRegion();
                super.onEndEndElement(uri, localName, name);
                if (pRegion.isContainsField() && !pRegion.isReseted()) {
                    this.currentNoteRegion.setContainsField(true);
                }
                return;
            }
            if (this.isNote(uri, localName, name)) {
                this.currentNoteRegion.process();
                this.currentNoteRegion = null;
            }
        }
        super.onEndEndElement(uri, localName, name);
    }

    protected abstract AbstractNoteBufferedRegion createNoteBufferedRegion(String var1, String var2, String var3, Attributes var4);

    protected abstract boolean isNote(String var1, String var2, String var3);
}

