/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.dump;

import fr.opensagres.xdocreport.core.XDocReportException;
import fr.opensagres.xdocreport.core.io.IOUtils;
import fr.opensagres.xdocreport.core.io.XDocArchive;
import fr.opensagres.xdocreport.core.utils.Base64Utility;
import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.document.IXDocReport;
import fr.opensagres.xdocreport.document.dump.DumperOptions;
import fr.opensagres.xdocreport.document.json.JSONObject;
import fr.opensagres.xdocreport.template.IContext;
import fr.opensagres.xdocreport.template.ITemplateEngine;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class DumpHelper {
    private static final String ESCAPED_DOUBLE_QUOTE = "\\\"";
    private static final String DOUBLE_QUOTE = "\"";
    public static final String JAVA_MAIN_DUMP_TEMPLATE = "JavaMainDump";

    public static String toDocumentAsBinary64(IXDocReport report) throws IOException {
        InputStream in = DumpHelper.getDocument(report);
        return Base64Utility.encode((InputStream)in);
    }

    public static InputStream getDocument(IXDocReport report) throws IOException {
        InputStream in = XDocArchive.getInputStream((XDocArchive)report.getOriginalDocumentArchive());
        return in;
    }

    private static String getDocumentFileName(IXDocReport report, IContext dumpContext) {
        String documentFileName = report.getId() + "." + report.getKind().toLowerCase();
        dumpContext.put("documentFile", (Object)documentFileName);
        return documentFileName;
    }

    public static void generateDocumentEntry(IXDocReport report, InputStream documentIn, IContext dumpContext, String src, File baseDir, ZipOutputStream out) throws IOException {
        if (out != null) {
            DumpHelper.generateDocumentZipEntry(report, documentIn, dumpContext, out, src);
        } else {
            DumpHelper.generateDocumentFile(report, documentIn, dumpContext, new File(baseDir, src));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateDocumentFile(IXDocReport report, InputStream documentIn, IContext dumpContext, File srcDir) throws FileNotFoundException, IOException {
        String documentFileName = DumpHelper.getDocumentFileName(report, dumpContext);
        File documentFile = new File(srcDir, documentFileName);
        documentFile.getParentFile().mkdirs();
        FileOutputStream documentOut = null;
        try {
            documentOut = new FileOutputStream(documentFile);
            IOUtils.copy((InputStream)documentIn, (OutputStream)documentOut);
        }
        finally {
            if (documentOut != null) {
                IOUtils.closeQuietly((OutputStream)documentOut);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateDocumentZipEntry(IXDocReport report, InputStream documentIn, IContext dumpContext, ZipOutputStream out, String src) throws IOException {
        String documentFileName = DumpHelper.getDocumentFileName(report, dumpContext);
        ZipEntry zipEntry = new ZipEntry(src + "/" + documentFileName);
        out.putNextEntry(zipEntry);
        try {
            IOUtils.copy((InputStream)documentIn, (OutputStream)out);
        }
        finally {
            out.closeEntry();
        }
    }

    public static String getClassName(IXDocReport report) {
        String className = report.getId();
        className = StringUtils.replaceEach((String)className, (String[])new String[]{"@", "."}, (String[])new String[]{"_", "_"});
        return className.substring(0, 1).toUpperCase() + className.substring(1, className.length());
    }

    public static String getClassNameFile(IContext dumpContext) {
        return (String)dumpContext.get("className") + ".java";
    }

    public static String toJSON(IContext context, boolean upperCaseFirstChar) {
        return DumpHelper.toJSON(context, upperCaseFirstChar, false);
    }

    public static String toJSON(IContext context, boolean upperCaseFirstChar, boolean formatAsJavaString) {
        JSONObject json = new JSONObject(context.getContextMap(), upperCaseFirstChar);
        String jsonString = json.toString();
        if (!formatAsJavaString) {
            return jsonString;
        }
        return jsonString.replace(DOUBLE_QUOTE, ESCAPED_DOUBLE_QUOTE);
    }

    public static void generateJSONEntry(IXDocReport report, IContext context, boolean upperCaseFirstChar, IContext dumpContext, String resourcesSrcPath, File baseDir, ZipOutputStream out) throws IOException {
        if (out != null) {
            DumpHelper.generateJSONZipEntry(report, context, upperCaseFirstChar, dumpContext, out, resourcesSrcPath);
        } else {
            DumpHelper.generateJSONFile(report, context, upperCaseFirstChar, dumpContext, new File(baseDir, resourcesSrcPath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateJSONFile(IXDocReport report, IContext context, boolean upperCaseFirstChar, IContext dumpContext, File srcDir) throws IOException {
        String jsonFileName = DumpHelper.getJSONFileName(report, dumpContext);
        JSONObject jsonObject = new JSONObject(context.getContextMap(), upperCaseFirstChar);
        File jsonFile = new File(srcDir, jsonFileName);
        jsonFile.getParentFile().mkdirs();
        FileWriter jsonWriter = null;
        try {
            jsonWriter = new FileWriter(jsonFile);
            String json = jsonObject.toString(1);
            IOUtils.write((String)json, (Writer)jsonWriter);
        }
        finally {
            if (jsonWriter != null) {
                IOUtils.closeQuietly((Writer)jsonWriter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateJSONZipEntry(IXDocReport report, IContext context, boolean upperCaseFirstChar, IContext dumpContext, ZipOutputStream out, String src) throws IOException {
        String jsonFileName = DumpHelper.getJSONFileName(report, dumpContext);
        JSONObject jsonObject = new JSONObject(context.getContextMap(), upperCaseFirstChar);
        ZipEntry zipEntry = new ZipEntry(src + "/" + jsonFileName);
        out.putNextEntry(zipEntry);
        OutputStreamWriter jsonWriter = null;
        try {
            jsonWriter = new OutputStreamWriter(out);
            String json = jsonObject.toString(1);
            IOUtils.write((String)json, (Writer)jsonWriter);
        }
        finally {
            if (jsonWriter != null) {
                ((Writer)jsonWriter).flush();
            }
            out.closeEntry();
        }
    }

    public static String getJSONFileName(IXDocReport report, IContext dumpContext) {
        String jsonFileName = report.getId() + ".json";
        dumpContext.put("jsonFile", (Object)jsonFileName);
        return jsonFileName;
    }

    public static void generateFieldsMetadataEntry(IXDocReport report, IContext dumpContext, String resourcesSrcPath, File baseDir, ZipOutputStream out) throws IOException {
        if (out != null) {
            DumpHelper.generateFieldsMetadataZipEntry(report, dumpContext, out, resourcesSrcPath);
        } else {
            DumpHelper.generateFieldsMetadataFile(report, dumpContext, new File(baseDir, resourcesSrcPath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateFieldsMetadataFile(IXDocReport report, IContext dumpContext, File srcDir) throws IOException {
        FieldsMetadata metadata = report.getFieldsMetadata();
        if (metadata != null) {
            String xmlFieldsFileName = DumpHelper.getXMLFieldsFileName(report, dumpContext);
            File xmlFieldsFile = new File(srcDir, xmlFieldsFileName);
            xmlFieldsFile.getParentFile().mkdirs();
            FileWriter xmlFieldsWriter = null;
            try {
                xmlFieldsWriter = new FileWriter(xmlFieldsFile);
                metadata.saveXML((Writer)xmlFieldsWriter, true, false);
            }
            finally {
                if (xmlFieldsWriter != null) {
                    IOUtils.closeQuietly((Writer)xmlFieldsWriter);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateFieldsMetadataZipEntry(IXDocReport report, IContext dumpContext, ZipOutputStream out, String src) throws IOException {
        FieldsMetadata metadata = report.getFieldsMetadata();
        if (metadata != null) {
            String xmlFieldsFileName = DumpHelper.getXMLFieldsFileName(report, dumpContext);
            ZipEntry zipEntry = new ZipEntry(src + "/" + xmlFieldsFileName);
            out.putNextEntry(zipEntry);
            OutputStreamWriter xmlFieldsWriter = null;
            try {
                xmlFieldsWriter = new OutputStreamWriter(out);
                metadata.saveXML((Writer)xmlFieldsWriter, true, false);
            }
            finally {
                if (xmlFieldsWriter != null) {
                    ((Writer)xmlFieldsWriter).flush();
                }
                out.closeEntry();
            }
        }
    }

    private static String getXMLFieldsFileName(IXDocReport report, IContext dumpContext) {
        String xmlFieldsFileName = report.getId() + ".fields.xml";
        dumpContext.put("xmlFieldsFile", (Object)xmlFieldsFileName);
        return xmlFieldsFileName;
    }

    public static IContext createDumpContext(IXDocReport report, ITemplateEngine templateEngine, DumperOptions option) throws IOException {
        IContext dumpContext = templateEngine.createContext();
        if (option != null) {
            String packageName = option.getPackageName();
            dumpContext.put("packageName", (Object)packageName);
        }
        String className = DumpHelper.getClassName(report);
        dumpContext.put("className", (Object)className);
        dumpContext.put("templateEngineKind", (Object)templateEngine.getKind());
        String outFileName = report.getId() + "_Out." + report.getKind().toLowerCase();
        dumpContext.put("outFileName", (Object)outFileName);
        return dumpContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generate(ITemplateEngine templateEngine, String templateName, IContext dumpContext, OutputStream out) throws IOException, XDocReportException {
        OutputStreamWriter javaWriter = null;
        try {
            javaWriter = new OutputStreamWriter(out);
            templateEngine.process(templateName, dumpContext, (Writer)javaWriter);
        }
        finally {
            if (javaWriter != null) {
                IOUtils.closeQuietly((Writer)javaWriter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void generateFile(ITemplateEngine templateEngine, String templateName, IContext dumpContext, File javaFile) throws IOException, XDocReportException {
        FileWriter javaWriter = null;
        try {
            javaFile.getParentFile().mkdirs();
            javaWriter = new FileWriter(javaFile);
            templateEngine.process(templateName, dumpContext, (Writer)javaWriter);
            if (javaWriter == null) return;
        }
        catch (Throwable throwable) {
            if (javaWriter == null) throw throwable;
            IOUtils.closeQuietly(javaWriter);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)javaWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateZipEntry(ITemplateEngine templateEngine, String templateName, IContext dumpContext, String entryName, ZipOutputStream out) throws IOException, XDocReportException {
        ZipEntry zipEntry = new ZipEntry(entryName);
        out.putNextEntry(zipEntry);
        OutputStreamWriter javaWriter = null;
        try {
            javaWriter = new OutputStreamWriter(out);
            templateEngine.process(templateName, dumpContext, (Writer)javaWriter);
        }
        finally {
            if (javaWriter != null) {
                ((Writer)javaWriter).flush();
            }
            out.closeEntry();
        }
    }

    public static void generateEntry(ITemplateEngine templateEngine, String templateName, IContext dumpContext, String entryName, File baseDir, ZipOutputStream out) throws IOException, XDocReportException {
        if (out != null) {
            DumpHelper.generateZipEntry(templateEngine, templateName, dumpContext, entryName, out);
        } else {
            File file = new File(baseDir, entryName);
            DumpHelper.generateFile(templateEngine, templateName, dumpContext, file);
        }
    }
}

