/*
 * Decompiled with CFR 0.152.
 */
package gr.abiss.mvn.plugins.jstools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.site.renderer.SiteRenderer;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.util.DirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBaseJstoolsReport
extends AbstractMavenReport {
    protected String outputBaseDirectory;
    protected MavenProject project;
    protected MavenProjectHelper helper;
    protected SiteRenderer siteRenderer;
    protected ArchiverManager archiverManager;
    protected String buildDir;
    protected File baseDir;
    private String jsDir;
    protected String includes;
    protected String excludes;
    protected boolean caseSensitive;

    public abstract String getBundleKey();

    protected SiteRenderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report." + this.getBundleKey() + ".description");
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report." + this.getBundleKey() + ".name");
    }

    public String getOutputName() {
        return this.getBundleKey() + "/index";
    }

    protected String getOutputDirectory() {
        return this.outputBaseDirectory + "/" + this.getBundleKey();
    }

    protected ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("jstools", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    protected MavenProject getProject() {
        return this.project;
    }

    public final void executeReport(Locale defaultLocale) throws MavenReportException {
        if (this.canGenerateReport()) {
            this.setUp(defaultLocale);
            this.doGenerateReport(defaultLocale);
            this.tearDown(defaultLocale);
        }
    }

    public abstract void doGenerateReport(Locale var1) throws MavenReportException;

    protected String getFileAsString(String path) throws IOException {
        String s = "";
        FileInputStream f = new FileInputStream(path);
        int x = f.available();
        byte[] b = new byte[x];
        f.read(b);
        s = new String(b);
        return s;
    }

    protected Set<File> getJavaScriptFiles() {
        DirectoryScanner ds = new DirectoryScanner();
        if (this.jsDir == null || this.jsDir.length() == 0) {
            this.jsDir = "src/main/js";
        }
        ds.setBasedir(this.jsDir);
        if (this.includes == null || this.includes.length() == 0) {
            this.includes = "**/*.js";
        }
        ds.setIncludes(this.includes.split(" "));
        if (this.excludes != null && this.excludes.length() > 0) {
            ds.setExcludes(this.excludes.split(" "));
        }
        ds.addDefaultExcludes();
        ds.setCaseSensitive(true);
        ds.scan();
        HashSet<File> files = new HashSet<File>();
        String[] relPaths = ds.getIncludedFiles();
        for (int i = 0; i < relPaths.length; ++i) {
            File file = new File(this.jsDir, relPaths[i]);
            files.add(file);
            this.getLog().debug((CharSequence)("File to process: " + file.getAbsolutePath()));
        }
        return files;
    }

    protected abstract void setUp(Locale var1) throws MavenReportException;

    protected abstract void tearDown(Locale var1) throws MavenReportException;
}

