/*
 * Decompiled with CFR 0.152.
 */
package gr.abiss.mvn.plugins.jstools;

import gr.abiss.mvn.plugins.jstools.AbstractBaseJstoolsReport;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;

public class EcmaUnitMojo
extends AbstractBaseJstoolsReport {
    private String ecmaunitHome;

    public void doGenerateReport(Locale defaultLocale) throws MavenReportException {
    }

    protected void setUp(Locale defaultLocale) throws MavenReportException {
        if (this.ecmaunitHome == null || this.ecmaunitHome.trim().length() == 0) {
            String ecmaunitDistFilename = this.getBundle(defaultLocale).getString("jsdoc.dist.filename");
            this.ecmaunitHome = this.buildDir + "/ecmaunit_run/" + ecmaunitDistFilename;
            String ecmaunitJar = this.baseDir + "/target/" + ecmaunitDistFilename + ".zip";
            try {
                InputStream input = ((Object)((Object)this)).getClass().getResourceAsStream("/" + ecmaunitDistFilename + ".zip");
                FileOutputStream output = new FileOutputStream(ecmaunitJar);
                IOUtils.copy((InputStream)input, (OutputStream)output);
                input.close();
                ((OutputStream)output).close();
            }
            catch (FileNotFoundException fe) {
                throw new MavenReportException("Cannot find " + ecmaunitDistFilename + ".zip" + " in classpath", (Exception)fe);
            }
            catch (IOException ioe) {
                throw new MavenReportException("Error copying " + ecmaunitDistFilename + ".zip" + " to target dir", (Exception)ioe);
            }
            File jarFile = new File(ecmaunitJar);
            try {
                UnArchiver unArchiver = this.archiverManager.getUnArchiver(jarFile);
                unArchiver.setSourceFile(jarFile);
                File destDir = new File(this.buildDir + "/site").getParentFile();
                destDir.mkdirs();
                unArchiver.setDestDirectory(destDir);
                unArchiver.extract();
            }
            catch (NoSuchArchiverException ae) {
                throw new MavenReportException("Unknown archiver type", (Exception)((Object)ae));
            }
            catch (ArchiverException ae) {
                throw new MavenReportException("Error unpacking " + jarFile + ": " + ae.toString(), (Exception)((Object)ae));
            }
        }
    }

    public boolean isExternalReport() {
        return false;
    }

    public String getBundleKey() {
        return "ecmaunit";
    }

    protected void tearDown(Locale defaultLocale) throws MavenReportException {
    }
}

