/*
 * Decompiled with CFR 0.152.
 */
package gr.abiss.mvn.plugins.jstools.utils;

import gr.abiss.mvn.plugins.jstools.utils.ClasspathResourceDiscoveryException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.log4j.Logger;

public class ClasspathResourceUtils {
    private static Logger log = Logger.getLogger(ClasspathResourceUtils.class);

    public static InputStream getResourceAsStream(String path) {
        InputStream is = ClasspathResourceUtils.getResourceAsStreamOrNull(path);
        if (is == null) {
            throw new ClasspathResourceDiscoveryException("Could not find resource in classpath: " + path);
        }
        return is;
    }

    public static byte[] getResourceBytesOrNull(String path) {
        InputStream is = ClasspathResourceUtils.getResourceAsStreamOrNull(path);
        byte[] data = null;
        if (is != null) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] bufferP = new byte[1024];
            try {
                int readP;
                while ((readP = is.read(bufferP)) > -1) {
                    os.write(bufferP, 0, readP);
                }
            }
            catch (IOException e) {
                throw new ClasspathResourceDiscoveryException("Could not read resource into memory");
            }
            data = os.toByteArray();
        }
        return data;
    }

    private static InputStream getResourceAsStreamOrNull(String path) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
    }

    public static String getResourceAsStringOrNull(String path) {
        String s = null;
        InputStream is = ClasspathResourceUtils.getResourceAsStreamOrNull(path);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Result stream of path [" + path + "]: " + is));
        }
        if (is != null) {
            StringBuffer sb;
            try {
                sb = ClasspathResourceUtils.inputStreamToStringBuffer(is);
            }
            catch (IOException e) {
                throw new ClasspathResourceDiscoveryException("Could not load classpath resource into memory", e);
            }
            s = sb.toString();
        }
        return s;
    }

    private static StringBuffer inputStreamToStringBuffer(InputStream is) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuffer sb = new StringBuffer();
        char[] charBuffer = new char[4096];
        int nbCharRead = 0;
        while ((nbCharRead = reader.read(charBuffer)) != -1) {
            sb.append(charBuffer, 0, nbCharRead);
        }
        reader.close();
        return sb;
    }
}

