/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.control;

import java.io.File;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.codehaus.groovy.control.ConfigurationException;
import org.codehaus.groovy.control.ParserPluginFactory;
import org.codehaus.groovy.control.io.NullWriter;

public class CompilerConfiguration {
    public static final CompilerConfiguration DEFAULT = new CompilerConfiguration();
    protected static final boolean DEFAULT_JSR_FLAG = true;
    private static boolean jsrGroovy;
    private int warningLevel;
    private String sourceEncoding;
    private PrintWriter output;
    private File targetDirectory;
    private LinkedList classpath;
    private boolean verbose;
    private boolean debug;
    private int tolerance;
    private String scriptBaseClass;
    private boolean useNewGroovy = CompilerConfiguration.getDefaultJsrFlag();
    private ParserPluginFactory pluginFactory;

    public CompilerConfiguration() {
        this.setWarningLevel(1);
        this.setSourceEncoding("US-ASCII");
        this.setOutput(null);
        this.setTargetDirectory((File)null);
        this.setClasspath("");
        this.setVerbose(false);
        this.setDebug(false);
        this.setTolerance(10);
        this.setScriptBaseClass(null);
        try {
            this.setSourceEncoding(System.getProperty("file.encoding", "US-ASCII"));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.setOutput(new PrintWriter(System.err));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.setClasspath(System.getProperty("java.class.path"));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            String target = System.getProperty("groovy.target.directory");
            if (target != null) {
                this.setTargetDirectory(target);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public CompilerConfiguration(Properties configuration) throws ConfigurationException {
        this();
        String text = null;
        int numeric = 0;
        numeric = this.getWarningLevel();
        try {
            text = configuration.getProperty("groovy.warnings", "likely errors");
            numeric = Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            if (text.equals("none")) {
                numeric = 0;
            }
            if (text.startsWith("likely")) {
                numeric = 1;
            }
            if (text.startsWith("possible")) {
                numeric = 2;
            }
            if (text.startsWith("paranoia")) {
                numeric = 3;
            }
            throw new ConfigurationException("unrecogized groovy.warnings: " + text);
        }
        this.setWarningLevel(numeric);
        text = configuration.getProperty("groovy.source.encoding");
        if (text != null) {
            this.setSourceEncoding(text);
        }
        if ((text = configuration.getProperty("groovy.target.directory")) != null) {
            this.setTargetDirectory(text);
        }
        if ((text = configuration.getProperty("groovy.classpath")) != null) {
            this.setClasspath(text);
        }
        if ((text = configuration.getProperty("groovy.output.verbose")) != null && text.equals("true")) {
            this.setVerbose(true);
        }
        if ((text = configuration.getProperty("groovy.output.debug")) != null && text.equals("true")) {
            this.setDebug(true);
        }
        numeric = 10;
        try {
            text = configuration.getProperty("groovy.errors.tolerance", "10");
            numeric = Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException(e);
        }
        this.setTolerance(numeric);
        text = configuration.getProperty("groovy.script.base");
        this.setScriptBaseClass(text);
        text = configuration.getProperty("groovy.jsr");
        if (text != null) {
            this.setUseNewGroovy(text.equalsIgnoreCase("true"));
        }
    }

    public int getWarningLevel() {
        return this.warningLevel;
    }

    public void setWarningLevel(int level) {
        this.warningLevel = level < 0 || level > 3 ? 1 : level;
    }

    public String getSourceEncoding() {
        return this.sourceEncoding;
    }

    public void setSourceEncoding(String encoding) {
        this.sourceEncoding = encoding;
    }

    public PrintWriter getOutput() {
        return this.output;
    }

    public void setOutput(PrintWriter output) {
        this.output = this.output == null ? new PrintWriter(NullWriter.DEFAULT) : output;
    }

    public File getTargetDirectory() {
        return this.targetDirectory;
    }

    public void setTargetDirectory(String directory) {
        this.targetDirectory = directory != null && directory.length() > 0 ? new File(directory) : null;
    }

    public void setTargetDirectory(File directory) {
        this.targetDirectory = directory;
    }

    public List getClasspath() {
        return this.classpath;
    }

    public void setClasspath(String classpath) {
        this.classpath = new LinkedList();
        StringTokenizer tokenizer = new StringTokenizer(classpath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            this.classpath.add(tokenizer.nextToken());
        }
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public int getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(int tolerance) {
        this.tolerance = tolerance;
    }

    public String getScriptBaseClass() {
        return this.scriptBaseClass;
    }

    public void setScriptBaseClass(String scriptBaseClass) {
        this.scriptBaseClass = scriptBaseClass;
    }

    public boolean isUseNewGroovy() {
        return this.useNewGroovy;
    }

    public void setUseNewGroovy(boolean useNewGroovy) {
        this.useNewGroovy = useNewGroovy;
    }

    public ParserPluginFactory getPluginFactory() {
        if (this.pluginFactory == null) {
            this.pluginFactory = ParserPluginFactory.newInstance(this.isUseNewGroovy());
        }
        return this.pluginFactory;
    }

    public void setPluginFactory(ParserPluginFactory pluginFactory) {
        this.pluginFactory = pluginFactory;
    }

    public static boolean isJsrGroovy() {
        return jsrGroovy;
    }

    public static void setJsrGroovy(boolean value) {
        jsrGroovy = value;
    }

    protected static boolean getDefaultJsrFlag() {
        String property = null;
        try {
            property = System.getProperty("groovy.jsr");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (property != null) {
            return "true".equalsIgnoreCase(property);
        }
        return true;
    }
}

