/*
 * Decompiled with CFR 0.152.
 */
package groovy.ui;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.codehaus.groovy.sandbox.ui.Prompt;
import org.codehaus.groovy.sandbox.ui.PromptFactory;
import org.codehaus.groovy.tools.ErrorReporter;

public class InteractiveShell {
    private final GroovyShell shell;
    private final Prompt prompt;
    private final InputStream in;
    private final PrintStream out;
    private final PrintStream err;
    private Object lastResult;
    private StringBuffer accepted = new StringBuffer();
    private String pending = null;
    private int line = 1;
    private boolean stale = false;
    private SourceUnit parser = null;
    private Exception error = null;
    private static final int COMMAND_ID_EXIT = 0;
    private static final int COMMAND_ID_HELP = 1;
    private static final int COMMAND_ID_DISCARD = 2;
    private static final int COMMAND_ID_DISPLAY = 3;
    private static final int COMMAND_ID_EXPLAIN = 4;
    private static final int COMMAND_ID_EXECUTE = 5;
    private static final int COMMAND_ID_BINDING = 6;
    private static final int COMMAND_ID_DISCARD_LOADED_CLASSES = 7;
    private static final int COMMAND_ID_INSPECT = 8;
    private static final int LAST_COMMAND_ID = 8;
    private static final String[] COMMANDS = new String[]{"exit", "help", "discard", "display", "explain", "execute", "binding", "discardclasses", "inspect"};
    private static final Map COMMAND_MAPPINGS = new HashMap();
    private static final Map COMMAND_HELP;

    public static void main(String[] args) {
        try {
            InteractiveShell groovy = new InteractiveShell();
            groovy.run(args);
        }
        catch (Exception e) {
            System.err.println("Caught: " + e);
            e.printStackTrace();
        }
    }

    public InteractiveShell() {
        this(System.in, System.out, System.err);
    }

    public InteractiveShell(InputStream in, PrintStream out, PrintStream err) {
        this(new Binding(), in, out, err);
    }

    public InteractiveShell(Binding binding, InputStream in, PrintStream out, PrintStream err) {
        this.in = in;
        this.out = out;
        this.err = err;
        this.prompt = PromptFactory.buildPrompt(in, out, err);
        this.prompt.setPrompt("groovy> ");
        this.shell = new GroovyShell(binding);
        Map map = this.shell.getContext().getVariables();
        if (map.get("shell") != null) {
            map.put("shell", this.shell);
        }
    }

    public void run(String[] args) throws Exception {
        String version = InvokerHelper.getVersion();
        this.out.println("Lets get Groovy!");
        this.out.println("================");
        this.out.println("Version: " + version + " JVM: " + System.getProperty("java.vm.version"));
        this.out.println("Type 'exit' to terminate the shell");
        this.out.println("Type 'help' for command help");
        this.out.println("Type 'go' to execute the statements");
        boolean running = true;
        while (running) {
            String command = this.read();
            if (command == null) {
                this.close();
                break;
            }
            this.reset();
            if (command.length() <= 0) continue;
            try {
                this.lastResult = this.shell.evaluate(command, "CommandLine.groovy");
            }
            catch (CompilationFailedException e) {
                this.err.println(e);
            }
            catch (Throwable e) {
                if (e instanceof InvokerInvocationException) {
                    InvokerInvocationException iie = (InvokerInvocationException)e;
                    e = iie.getCause();
                }
                this.err.println("Caught: " + e);
                StackTraceElement[] stackTrace = e.getStackTrace();
                for (int i = 0; i < stackTrace.length; ++i) {
                    StackTraceElement element = stackTrace[i];
                    String fileName = element.getFileName();
                    if (fileName != null && fileName.endsWith(".java")) continue;
                    this.err.println("\tat " + element);
                }
            }
        }
    }

    protected void close() {
        this.prompt.close();
    }

    protected void reset() {
        this.stale = true;
        this.pending = null;
        this.line = 1;
        this.parser = null;
        this.error = null;
    }

    protected String read() {
        this.reset();
        this.out.println("");
        boolean complete = false;
        boolean done = false;
        while (!done) {
            try {
                this.pending = this.prompt.readLine();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (this.pending == null || COMMAND_MAPPINGS.containsKey(this.pending) && (Integer)COMMAND_MAPPINGS.get(this.pending) == 0) {
                return null;
            }
            if (COMMAND_MAPPINGS.containsKey(this.pending)) {
                int code = (Integer)COMMAND_MAPPINGS.get(this.pending);
                switch (code) {
                    case 1: {
                        this.displayHelp();
                        break;
                    }
                    case 2: {
                        this.reset();
                        done = true;
                        break;
                    }
                    case 3: {
                        this.displayStatement();
                        break;
                    }
                    case 4: {
                        this.explainStatement();
                        break;
                    }
                    case 6: {
                        this.displayBinding();
                        break;
                    }
                    case 5: {
                        if (complete) {
                            done = true;
                            break;
                        }
                        this.err.println("statement not complete");
                        break;
                    }
                    case 7: {
                        this.resetLoadedClasses();
                        break;
                    }
                    case 8: {
                        this.inspect();
                    }
                }
                continue;
            }
            this.freshen();
            if (this.pending.trim().equals("")) {
                this.accept();
                continue;
            }
            String code = this.current();
            if (this.parse(code, 1)) {
                this.accept();
                complete = true;
                continue;
            }
            if (this.error == null) {
                this.accept();
                continue;
            }
            this.report();
        }
        return this.accepted(complete);
    }

    private void inspect() {
        if (null == this.lastResult) {
            this.err.println("nothing to inspect (preceding \"go\" missing?)");
            return;
        }
        try {
            Class<?> browserClass = Class.forName("groovy.inspect.swingui.ObjectBrowser");
            Method inspectMethod = browserClass.getMethod("inspect", Object.class);
            inspectMethod.invoke(browserClass, this.lastResult);
        }
        catch (Exception e) {
            this.err.println("cannot invoke ObjectBrowser");
            e.printStackTrace();
        }
    }

    private String accepted(boolean complete) {
        if (complete) {
            return this.accepted.toString();
        }
        return "";
    }

    private String current() {
        return this.accepted.toString() + this.pending + "\n";
    }

    private void accept() {
        this.accepted.append(this.pending).append("\n");
        ++this.line;
    }

    private void freshen() {
        if (this.stale) {
            this.accepted.setLength(0);
            this.stale = false;
        }
    }

    private boolean parse(String code, int tolerance) {
        boolean parsed = false;
        this.parser = null;
        this.error = null;
        try {
            this.parser = SourceUnit.create("groovysh script", code, tolerance);
            this.parser.parse();
            parsed = true;
        }
        catch (CompilationFailedException e) {
            if (this.parser.getErrorCollector().getErrorCount() > 1 || !this.parser.failedWithUnexpectedEOF()) {
                this.error = e;
            }
        }
        catch (Exception e) {
            this.error = e;
        }
        return parsed;
    }

    private void report() {
        this.err.println("Discarding invalid text:");
        new ErrorReporter(this.error, false).write(this.err);
    }

    private void displayHelp() {
        this.out.println("Available commands (must be entered without extraneous characters):");
        for (int i = 0; i <= 8; ++i) {
            this.out.println((String)COMMAND_HELP.get(COMMANDS[i]));
        }
    }

    private void displayStatement() {
        String[] lines = this.accepted.toString().split("\n");
        for (int i = 0; i < lines.length; ++i) {
            this.out.println(i + 1 + "> " + lines[i]);
        }
    }

    private void displayBinding() {
        this.out.println("Available variables in the current binding");
        Binding context = this.shell.getContext();
        Map variables = context.getVariables();
        Set set = variables.keySet();
        if (set.isEmpty()) {
            this.out.println("The current binding is empty.");
        } else {
            Iterator it = set.iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                this.out.println(key + " = " + variables.get(key));
            }
        }
    }

    private void explainStatement() {
        if (this.parse(this.accepted(true), 10) || this.error == null) {
            this.out.println("Parse tree:");
        } else {
            this.out.println("Statement does not parse");
        }
    }

    private void resetLoadedClasses() {
        this.shell.resetLoadedClasses();
        this.out.println("all former unbound class definitions are discarded");
    }

    static {
        for (int i = 0; i <= 8; ++i) {
            COMMAND_MAPPINGS.put(COMMANDS[i], new Integer(i));
        }
        COMMAND_MAPPINGS.put("quit", new Integer(0));
        COMMAND_MAPPINGS.put("go", new Integer(5));
        COMMAND_HELP = new HashMap();
        COMMAND_HELP.put(COMMANDS[0], "exit/quit        - terminates processing");
        COMMAND_HELP.put(COMMANDS[1], "help             - displays this help text");
        COMMAND_HELP.put(COMMANDS[2], "discard           - discards the current statement");
        COMMAND_HELP.put(COMMANDS[3], "display           - displays the current statement");
        COMMAND_HELP.put(COMMANDS[4], "explain           - explains the parsing of the current statement (currently disabled)");
        COMMAND_HELP.put(COMMANDS[5], "execute/go        - temporary command to cause statement execution");
        COMMAND_HELP.put(COMMANDS[6], "binding           - shows the binding used by this interactive shell");
        COMMAND_HELP.put(COMMANDS[7], "discardclasses    - discards all former unbound class definitions");
        COMMAND_HELP.put(COMMANDS[8], "inspect           - opens ObjectBrowser on expression returned from previous \"go\"");
    }
}

