/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.expr;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.syntax.Token;

public class BinaryExpression
extends Expression {
    private Expression leftExpression;
    private Expression rightExpression;
    private Token operation;

    public BinaryExpression(Expression leftExpression, Token operation, Expression rightExpression) {
        this.leftExpression = leftExpression;
        this.operation = operation;
        this.rightExpression = rightExpression;
    }

    private static boolean isFloatingPoint(Class cls) {
        return cls == Double.class || cls == Float.class;
    }

    private static boolean isInteger(Class cls) {
        return cls == Integer.class || cls == Byte.class || cls == Short.class || cls == Character.class;
    }

    private static boolean isLong(Class cls) {
        return cls == Long.class;
    }

    private static boolean isBigDecimal(Class cls) {
        return cls == BigDecimal.class;
    }

    private static boolean isBigInteger(Class cls) {
        return cls == BigInteger.class;
    }

    public String toString() {
        return super.toString() + "[" + this.leftExpression + this.operation + this.rightExpression + "]";
    }

    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitBinaryExpression(this);
    }

    public Expression transformExpression(ExpressionTransformer transformer) {
        return new BinaryExpression(transformer.transform(this.leftExpression), this.operation, transformer.transform(this.rightExpression));
    }

    public Expression getLeftExpression() {
        return this.leftExpression;
    }

    public void setLeftExpression(Expression leftExpression) {
        this.leftExpression = leftExpression;
    }

    public void setRightExpression(Expression rightExpression) {
        this.rightExpression = rightExpression;
    }

    public Token getOperation() {
        return this.operation;
    }

    public Expression getRightExpression() {
        return this.rightExpression;
    }

    public String getText() {
        if (this.operation.getType() == 30) {
            return this.leftExpression.getText() + "[" + this.rightExpression.getText() + "]";
        }
        return "(" + this.leftExpression.getText() + " " + this.operation.getText() + " " + this.rightExpression.getText() + ")";
    }

    public static BinaryExpression newAssignmentExpression(String variable, Expression rhs) {
        VariableExpression lhs = new VariableExpression(variable);
        Token operator = Token.newPlaceholder(100);
        return new BinaryExpression(lhs, operator, rhs);
    }

    public static BinaryExpression newInitializationExpression(String variable, ClassNode type, Expression rhs) {
        VariableExpression lhs = new VariableExpression(variable);
        if (type != null) {
            lhs.setType(type);
        }
        Token operator = Token.newPlaceholder(100);
        return new BinaryExpression(lhs, operator, rhs);
    }
}

