/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.control;

import com.thoughtworks.xstream.XStream;
import groovy.lang.GroovyClassLoader;
import groovyjarjarantlr.MismatchedTokenException;
import groovyjarjarantlr.NoViableAltException;
import groovyjarjarantlr.RecognitionException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.Janitor;
import org.codehaus.groovy.control.ParserPlugin;
import org.codehaus.groovy.control.ProcessingUnit;
import org.codehaus.groovy.control.io.FileReaderSource;
import org.codehaus.groovy.control.io.ReaderSource;
import org.codehaus.groovy.control.io.StringReaderSource;
import org.codehaus.groovy.control.io.URLReaderSource;
import org.codehaus.groovy.control.messages.ExceptionMessage;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.Reduction;
import org.codehaus.groovy.syntax.SourceSummary;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.syntax.UnexpectedTokenException;
import org.codehaus.groovy.tools.Utilities;

public class SourceUnit
extends ProcessingUnit {
    private ParserPlugin parserPlugin;
    protected ReaderSource source;
    protected String name;
    protected Reduction cst;
    protected SourceSummary sourceSummary;
    protected ModuleNode ast;

    public SourceUnit(String name, ReaderSource source, CompilerConfiguration flags, GroovyClassLoader loader, ErrorCollector er) {
        super(flags, loader, er);
        this.name = name;
        this.source = source;
    }

    public SourceUnit(File source, CompilerConfiguration configuration, GroovyClassLoader loader, ErrorCollector er) {
        this(source.getPath(), new FileReaderSource(source, configuration), configuration, loader, er);
    }

    public SourceUnit(URL source, CompilerConfiguration configuration, GroovyClassLoader loader, ErrorCollector er) {
        this(source.getPath(), new URLReaderSource(source, configuration), configuration, loader, er);
    }

    public SourceUnit(String name, String source, CompilerConfiguration configuration, GroovyClassLoader loader, ErrorCollector er) {
        this(name, new StringReaderSource(source, configuration), configuration, loader, er);
    }

    public String getName() {
        return this.name;
    }

    public Reduction getCST() {
        return this.cst;
    }

    public SourceSummary getSourceSummary() {
        return this.sourceSummary;
    }

    public ModuleNode getAST() {
        return this.ast;
    }

    public boolean failedWithUnexpectedEOF() {
        boolean result = false;
        if (this.getErrorCollector().hasErrors()) {
            Token unexpected;
            SyntaxException cause;
            Message last = this.getErrorCollector().getLastError();
            if (last instanceof SyntaxErrorMessage && (cause = ((SyntaxErrorMessage)last).getCause()) instanceof UnexpectedTokenException && (unexpected = ((UnexpectedTokenException)cause).getUnexpectedToken()).isA(-1)) {
                result = true;
            }
            if (last instanceof ExceptionMessage) {
                RecognitionException antlrException;
                ExceptionMessage exceptionMessage = (ExceptionMessage)last;
                Exception cause2 = exceptionMessage.getCause();
                if (cause2 instanceof NoViableAltException) {
                    antlrException = (NoViableAltException)cause2;
                    result = this.isEofToken(antlrException.token);
                }
                if (cause2 instanceof MismatchedTokenException) {
                    antlrException = (MismatchedTokenException)cause2;
                    result = this.isEofToken(((MismatchedTokenException)antlrException).token);
                }
            }
        }
        return result;
    }

    protected boolean isEofToken(groovyjarjarantlr.Token token) {
        return token.getType() == 1;
    }

    public static SourceUnit create(String name, String source) {
        CompilerConfiguration configuration = new CompilerConfiguration();
        configuration.setTolerance(1);
        return new SourceUnit(name, source, configuration, null, new ErrorCollector(configuration));
    }

    public static SourceUnit create(String name, String source, int tolerance) {
        CompilerConfiguration configuration = new CompilerConfiguration();
        configuration.setTolerance(tolerance);
        return new SourceUnit(name, source, configuration, null, new ErrorCollector(configuration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse() throws CompilationFailedException {
        if (this.phase > 2) {
            throw new GroovyBugError("parsing is already complete");
        }
        if (this.phase == 1) {
            this.nextPhase();
        }
        Reader reader = null;
        reader = this.source.getReader();
        this.parserPlugin = this.getConfiguration().getPluginFactory().createParserPlugin();
        this.cst = this.parserPlugin.parseCST(this, reader);
        this.sourceSummary = this.parserPlugin.getSummary();
        reader.close();
        Object var4_2 = null;
        if (reader == null) return;
        try {
            reader.close();
            return;
        }
        catch (IOException e2) {}
        return;
        {
            catch (IOException e) {
                this.getErrorCollector().addFatalError(new SimpleMessage(e.getMessage(), this));
                Object var4_3 = null;
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (IOException e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void convert() throws CompilationFailedException {
        if (this.phase == 2 && this.phaseComplete) {
            this.gotoPhase(3);
        }
        if (this.phase != 3) {
            throw new GroovyBugError("SourceUnit not ready for convert()");
        }
        try {
            this.ast = this.parserPlugin.buildAST(this, this.classLoader, this.cst);
            this.ast.setDescription(this.name);
        }
        catch (SyntaxException e) {
            this.getErrorCollector().addError(new SyntaxErrorMessage(e, this));
        }
        if ("xml".equals(System.getProperty("groovy.ast"))) {
            this.saveAsXML(this.name, this.ast);
        }
    }

    private void saveAsXML(String name, ModuleNode ast) {
        XStream xstream = new XStream();
        try {
            xstream.toXML((Object)ast, (Writer)new FileWriter(name + ".xml"));
            System.out.println("Written AST to " + name + ".xml");
        }
        catch (Exception e) {
            System.out.println("Couldn't write to " + name + ".xml");
            e.printStackTrace();
        }
    }

    public String getSample(int line, int column, Janitor janitor) {
        String sample = null;
        String text = this.source.getLine(line, janitor);
        if (text != null) {
            if (column > 0) {
                String marker = Utilities.repeatString(" ", column - 1) + "^";
                if (column > 40) {
                    int start = column - 30 - 1;
                    int end = column + 10 > text.length() ? text.length() : column + 10 - 1;
                    sample = "   " + text.substring(start, end) + Utilities.eol() + "   " + marker.substring(start, marker.length());
                } else {
                    sample = "   " + text + Utilities.eol() + "   " + marker;
                }
            } else {
                sample = text;
            }
        }
        return sample;
    }

    public void addException(Exception e) throws CompilationFailedException {
        this.getErrorCollector().addException(e, this);
    }

    public void addError(SyntaxException se) throws CompilationFailedException {
        this.getErrorCollector().addError(se, this);
    }
}

