/*
 * Decompiled with CFR 0.152.
 */
package uk.co.wilson.net.xmlrpc;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;
import uk.co.wilson.net.xmlrpc.XMLRPCFailException;
import uk.co.wilson.xml.MinML;

public class XMLRPCMessageProcessor
extends MinML {
    private static final String startResponse = "<methodResponse>\n\t<params>\n\t\t<param>\n";
    private static final String endResponse = "\n\t\t</param>\n\t</params>\n</methodResponse>";
    private static final String startError = "<methodResponse>\n\t<fault>\n\t\t<value>\n\t\t\t<struct>\n\t\t\t\t<member>\n\t\t\t\t\t<name>faultCode</name>\n\t\t\t\t\t<value><int>";
    private static final String middleError = "</int></value>\n\t\t\t\t</member>\n\t\t\t\t<member>\n\t\t\t\t\t<name>faultString</name>\n\t\t\t\t\t<value><string>";
    private static final String endError = "</string></value>\n\t\t\t\t</member>\n\t\t\t</struct>\n\t\t</value>\n\t</fault>\n</methodResponse>\n";
    private static final byte[] translateTable = "BBBBBBBBBBAABBABBBBBBBBBBBBBBBBBABBBBBBBBBB>BBB?456789:;<=BBB@BBB\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019BBBBBB\u001a\u001b\u001c\u001d\u001e\u001f !\"#$%&'()*+,-./0123".getBytes();
    protected static final Map elements = new HashMap();
    private Object params = null;
    private Object name = null;
    private String methodName = null;
    private Map struct = null;
    private List array = null;
    private Boolean inArray = Boolean.FALSE;
    private Stack aggregateStack = new Stack();
    private boolean gotValue = false;
    private final StringBuffer buffer = new StringBuffer();
    private final DateFormat dateTime = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");
    private final DateFormat dateTime1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final Boolean[] bools = new Boolean[]{new Boolean(false), new Boolean(true)};
    static /* synthetic */ Class class$java$lang$Object;

    public static StringBuffer emitCall(StringBuffer buffer, String methodName, Object[] params, int numberOfparams) throws XMLRPCFailException {
        XMLRPCMessageProcessor.encodeString(buffer.append("<methodCall>\n\t<methodName>"), methodName).append("</methodName>\n\t<params>\n");
        for (int i = 0; i != numberOfparams; ++i) {
            XMLRPCMessageProcessor.emit(buffer.append("\t\t<param>"), params[i]).append("</param>\n");
        }
        return buffer.append("\t</params>\n</methodCall>\n");
    }

    public static StringBuffer emitResult(StringBuffer buffer, Object result) throws XMLRPCFailException {
        buffer.append(startResponse);
        XMLRPCMessageProcessor.emit(buffer, result);
        buffer.append(endResponse);
        return buffer;
    }

    public static StringBuffer emitError(StringBuffer buffer, int codeValue, String message) throws XMLRPCFailException {
        buffer.append(startError);
        XMLRPCMessageProcessor.emit(buffer, String.valueOf(codeValue));
        buffer.append(middleError);
        XMLRPCMessageProcessor.emit(buffer, message);
        buffer.append(endError);
        return buffer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static StringBuffer emit(StringBuffer buffer, Object param) throws XMLRPCFailException {
        if (param == null) {
            throw new XMLRPCFailException("an XML-RPC data value cannot be null", 0);
        }
        Emitter emitter = (Emitter)elements.get(param.getClass());
        if (emitter == null) {
            if (param instanceof List) {
                Iterator iterator = ((List)param).iterator();
                buffer.append("<value><array><data>");
                while (iterator.hasNext()) {
                    XMLRPCMessageProcessor.emit(buffer, iterator.next());
                }
                buffer.append("</data></array></value>");
                return buffer;
            }
            if (param instanceof Map) {
                Iterator iterator = ((Map)param).entrySet().iterator();
                buffer.append("<value><struct>");
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Object name = entry.getKey();
                    if (name == null) {
                        throw new XMLRPCFailException("the name of a struct element cannot be null", 0);
                    }
                    XMLRPCMessageProcessor.emit(XMLRPCMessageProcessor.encodeString(buffer.append("<member><name>"), name.toString()).append("</name>"), entry.getValue()).append("</member>");
                }
                buffer.append("</struct></value>");
                return buffer;
            }
            Class<?> superClass = param.getClass();
            while (true) {
                Emitter superEmitter;
                if ((superEmitter = (Emitter)elements.get(superClass)) != null) {
                    superEmitter.emit(buffer, param);
                    return buffer;
                }
                if (superClass == (class$java$lang$Object == null ? XMLRPCMessageProcessor.class$("java.lang.Object") : class$java$lang$Object)) {
                    throw new XMLRPCFailException(param.getClass() + " is not a supported XML-RPC data type", 0);
                }
                superClass = superClass.getSuperclass();
            }
        }
        emitter.emit(buffer, param);
        return buffer;
    }

    public static StringBuffer encodeString(StringBuffer buffer, String string) throws XMLRPCFailException {
        for (int i = 0; i != string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= ' ' || c == '\t' || c == '\n' || c == '\r') {
                if (c == '>') {
                    buffer.append("&gt;");
                    continue;
                }
                if (c == '<') {
                    buffer.append("&lt;");
                    continue;
                }
                if (c == '&') {
                    buffer.append("&amp;");
                    continue;
                }
                if (c > '\u00ff') {
                    if (c > '\ud800' && (c < '\ue000' || c >= '\ufffe')) {
                        throw new XMLRPCFailException("Can't include character with value 0x" + Integer.toHexString(c) + " in a well formed XML document", 0);
                    }
                    buffer.append("&#x").append(Integer.toHexString(c)).append(';');
                    continue;
                }
                buffer.append(c);
                continue;
            }
            throw new XMLRPCFailException("Can't include character with value 0x" + Integer.toHexString(c) + " in a well formed XML document", 0);
        }
        return buffer;
    }

    public void parseMessage(String message) throws IOException, XMLRPCFailException {
        try {
            this.parse(new StringReader(message));
        }
        catch (XMLRPCFailException e) {
            throw e;
        }
        catch (SAXException e) {
            throw new XMLRPCFailException("XML error in response from remote system: " + e.getMessage(), 0);
        }
    }

    public void parseMessage(InputStream in) throws IOException, XMLRPCFailException {
        try {
            this.parse(new InputStreamReader(in, "ISO-8859-1"));
        }
        catch (XMLRPCFailException e) {
            throw e;
        }
        catch (SAXException e) {
            throw new XMLRPCFailException("XML error in response from remote system: " + e.getMessage(), 0);
        }
    }

    public List getParams() {
        return (List)this.params;
    }

    public String getMethodname() {
        return this.methodName;
    }

    public void startElement(String name, AttributeList attributes) {
        if ("value".equals(name) || "name".equals(name) || "methodName".equals(name)) {
            this.buffer.setLength(0);
            this.gotValue = false;
            this.aggregateStack.push(this.inArray);
            this.inArray = Boolean.FALSE;
        } else if ("struct".equals(name)) {
            this.aggregateStack.push(this.struct);
            this.aggregateStack.push(this.name);
            this.struct = new HashMap();
        } else if ("array".equals(name) || "params".equals(name)) {
            this.aggregateStack.push(this.inArray);
            this.inArray = Boolean.TRUE;
            this.aggregateStack.push(this.array);
            this.array = new ArrayList();
        }
    }

    public void characters(char[] ch, int start, int length) {
        this.buffer.append(ch, start, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endElement(String name) throws SAXException {
        if ("value".equals(name)) {
            if (!this.gotValue) {
                this.params = this.buffer.toString();
                this.gotValue = true;
            }
            this.inArray = (Boolean)this.aggregateStack.pop();
            if (this.inArray.booleanValue()) {
                this.array.add(this.params);
            }
        } else if ("string".equals(name)) {
            this.params = this.buffer.toString();
            this.gotValue = true;
        } else if ("i4".equals(name) || "int".equals(name)) {
            this.params = new Integer(this.buffer.toString());
            this.gotValue = true;
        } else if ("boolean".equals(name)) {
            try {
                this.params = this.bools[Integer.parseInt(this.buffer.toString())];
            }
            catch (RuntimeException e) {
                throw new XMLRPCFailException("bad Boolean value: " + this.buffer.toString(), 0);
            }
            this.gotValue = true;
        } else if ("dateTime.iso8601".equals(name)) {
            try {
                XMLRPCMessageProcessor e = this;
                synchronized (e) {
                    this.params = this.dateTime.parse(this.buffer.toString());
                }
            }
            catch (ParseException e) {
                try {
                    XMLRPCMessageProcessor xMLRPCMessageProcessor = this;
                    synchronized (xMLRPCMessageProcessor) {
                        this.params = this.dateTime1.parse(this.buffer.toString());
                    }
                }
                catch (ParseException e1) {
                    throw new XMLRPCFailException(e.getMessage(), 0);
                }
            }
            this.gotValue = true;
        } else if ("base64".equals(name)) {
            int bytesIndex = 0;
            int byteShift = 4;
            int tmp = 0;
            boolean done = false;
            for (int i = 0; i != this.buffer.length(); ++i) {
                int sixBit;
                char c = this.buffer.charAt(i);
                int n = sixBit = c < '{' ? translateTable[c] : 66;
                if (sixBit < 64) {
                    if (done) {
                        throw new XMLRPCFailException("= character not at end of base64 value", 0);
                    }
                    tmp = tmp << 6 | sixBit;
                    if (byteShift-- != 4) {
                        this.buffer.setCharAt(bytesIndex++, (char)(tmp >> byteShift * 2 & 0xFF));
                    }
                } else if (sixBit == 64) {
                    --byteShift;
                    done = true;
                } else if (sixBit == 66) {
                    throw new XMLRPCFailException("bad character in base64 value", 0);
                }
                if (byteShift != 0) continue;
                byteShift = 4;
            }
            this.buffer.setLength(bytesIndex);
            try {
                this.params = this.buffer.toString().getBytes("ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                throw new XMLRPCFailException("Base 64 decode produced byte values > 255", 0);
            }
            this.gotValue = true;
        } else if ("double".equals(name)) {
            this.params = new BigDecimal(this.buffer.toString());
            this.gotValue = true;
        } else if ("name".equals(name)) {
            this.name = this.buffer.toString();
            this.inArray = (Boolean)this.aggregateStack.pop();
        } else if ("member".equals(name)) {
            this.struct.put(this.name, this.params);
        } else if ("struct".equals(name)) {
            this.params = this.struct;
            this.name = (String)this.aggregateStack.pop();
            this.struct = (Map)this.aggregateStack.pop();
        } else if ("array".equals(name) || "params".equals(name)) {
            this.params = this.array;
            this.array = (List)this.aggregateStack.pop();
            this.inArray = (Boolean)this.aggregateStack.pop();
        } else if ("methodName".equals(name)) {
            this.methodName = this.buffer.toString();
            this.inArray = (Boolean)this.aggregateStack.pop();
        } else if ("fault".equals(name)) {
            String faultStringValue;
            int faultCodeValue;
            Object faultCode = ((Map)this.params).get("faultCode");
            Object faultString = ((Map)this.params).get("faultString");
            if (faultCode instanceof Integer) {
                faultCodeValue = (Integer)faultCode;
                faultStringValue = faultString.toString();
            } else {
                faultCodeValue = 0;
                faultStringValue = faultString.toString() + " : " + faultCode.toString();
            }
            throw new XMLRPCFailException(faultStringValue, faultCodeValue);
        }
    }

    static {
        final char[] tTable = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
        elements.put(Integer.class, new Emitter(){

            public void emit(StringBuffer buffer, Object integer) {
                buffer.append("<value><i4>").append(integer).append("</i4></value>");
            }
        });
        elements.put(Character.class, elements.get(Integer.class));
        elements.put(Byte.class, elements.get(Integer.class));
        elements.put(Short.class, elements.get(Integer.class));
        elements.put(Double.class, new Emitter(){

            public void emit(StringBuffer buffer, Object number) {
                buffer.append("<value><double>").append(number).append("</double></value>");
            }
        });
        elements.put(Float.class, elements.get(Double.class));
        elements.put(BigDecimal.class, elements.get(Double.class));
        elements.put(String.class, new Emitter(){

            public void emit(StringBuffer buffer, Object string) throws XMLRPCFailException {
                XMLRPCMessageProcessor.encodeString(buffer.append("<value><string>"), string.toString()).append("</string></value>");
            }
        });
        elements.put(Boolean.class, new Emitter(){

            public void emit(StringBuffer buffer, Object bool) {
                buffer.append("<value><boolean>").append((Boolean)bool != false ? "1" : "0").append("</boolean></value>");
            }
        });
        elements.put([B.class, new Emitter(){

            public void emit(StringBuffer buffer, Object bytes) {
                int charCount = 0;
                byte[] data = (byte[])bytes;
                int numChars = (data.length + 2) / 3 * 4;
                int dLimit = data.length / 3 * 3;
                buffer.ensureCapacity(numChars + 128 + data.length / 54);
                buffer.append("<value><base64>\n");
                for (int dIndex = 0; dIndex != dLimit; dIndex += 3) {
                    int d = (data[dIndex] & 0xFF) << 16 | (data[dIndex + 1] & 0xFF) << 8 | data[dIndex + 2] & 0xFF;
                    buffer.append(tTable[d >> 18]);
                    buffer.append(tTable[d >> 12 & 0x3F]);
                    buffer.append(tTable[d >> 6 & 0x3F]);
                    buffer.append(tTable[d & 0x3F]);
                    if (++charCount != 18) continue;
                    buffer.append('\n');
                    charCount = 0;
                }
                if (dLimit != data.length) {
                    int d = (data[dLimit] & 0xFF) << 16;
                    if (dLimit + 1 != data.length) {
                        d |= (data[dLimit + 1] & 0xFF) << 8;
                    }
                    buffer.append(tTable[d >> 18]);
                    buffer.append(tTable[d >> 12 & 0x3F]);
                    buffer.append(dLimit + 1 < data.length ? tTable[d >> 6 & 0x3F] : (char)'=');
                    buffer.append('=');
                }
                buffer.append("\n</base64></value>");
            }
        });
        elements.put(Date.class, new Emitter(){
            private final DateFormat dateTime = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");

            public synchronized void emit(StringBuffer buffer, Object date) {
                buffer.append("<value><dateTime.iso8601>").append(this.dateTime.format((Date)date)).append("</dateTime.iso8601></value>");
            }
        });
    }

    protected static interface Emitter {
        public void emit(StringBuffer var1, Object var2) throws XMLRPCFailException;
    }
}

