/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.syntax.Token;

public class EnumVisitor
extends ClassCodeVisitorSupport {
    private static final int FS = 24;
    private static final int PS = 9;
    private static final int PUBLIC_FS = 25;
    private static final int PRIVATE_FS = 26;
    private final CompilationUnit compilationUnit;
    private final SourceUnit sourceUnit;

    public EnumVisitor(CompilationUnit cu, SourceUnit su) {
        this.compilationUnit = cu;
        this.sourceUnit = su;
    }

    public void visitClass(ClassNode node) {
        if (!this.isEnum(node)) {
            return;
        }
        this.completeEnum(node);
    }

    protected SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    private boolean isEnum(ClassNode node) {
        return (node.getModifiers() & 0x4000) != 0;
    }

    private void completeEnum(ClassNode enumClass) {
        ClassNode enumArray = enumClass.makeArray();
        FieldNode values = new FieldNode("$VALUES", 26, enumArray, enumClass, null);
        values.setSynthetic(true);
        MethodNode valuesMethod = new MethodNode("values", 25, enumArray, new Parameter[0], ClassNode.EMPTY_ARRAY, null);
        valuesMethod.setSynthetic(true);
        BlockStatement code = new BlockStatement();
        code.addStatement(new ReturnStatement(new MethodCallExpression((Expression)new FieldExpression(values), "clone", MethodCallExpression.NO_ARGUMENTS)));
        valuesMethod.setCode(code);
        enumClass.addMethod(valuesMethod);
        Parameter stringParameter = new Parameter(ClassHelper.STRING_TYPE, "name");
        MethodNode valueOfMethod = new MethodNode("valueOf", 9, enumClass, new Parameter[]{stringParameter}, ClassNode.EMPTY_ARRAY, null);
        ArgumentListExpression callArguments = new ArgumentListExpression();
        callArguments.addExpression(new ClassExpression(enumClass));
        callArguments.addExpression(new VariableExpression("name"));
        BlockStatement code2 = new BlockStatement();
        code2.addStatement(new ReturnStatement(new MethodCallExpression((Expression)new ClassExpression(ClassHelper.Enum_Type), "valueOf", (Expression)callArguments)));
        valueOfMethod.setCode(code2);
        enumClass.addMethod(valueOfMethod);
        this.addConstructor(enumClass);
        Parameter[] parameter = new Parameter[]{new Parameter(ClassHelper.OBJECT_TYPE.makeArray(), "para")};
        MethodNode initMethod = new MethodNode("$INIT", 26, enumClass, parameter, ClassNode.EMPTY_ARRAY, null);
        initMethod.setSynthetic(true);
        ConstructorCallExpression cce = new ConstructorCallExpression(ClassNode.THIS, new ArgumentListExpression(new SpreadExpression(new VariableExpression("para"))));
        code2 = new BlockStatement();
        code2.addStatement(new ReturnStatement(cce));
        initMethod.setCode(code2);
        enumClass.addMethod(initMethod);
        List fields = enumClass.getFields();
        ArrayList arrayInit = new ArrayList();
        int value = -1;
        Token assign = Token.newSymbol(100, -1, -1);
        ArrayList<ExpressionStatement> block = new ArrayList<ExpressionStatement>();
        Iterator iterator = fields.iterator();
        while (iterator.hasNext()) {
            FieldNode field = (FieldNode)iterator.next();
            if ((field.getModifiers() & 0x4000) == 0) continue;
            ArgumentListExpression args = new ArgumentListExpression();
            args.addExpression(new ConstantExpression(field.getName()));
            args.addExpression(new ConstantExpression(new Integer(++value)));
            if (field.getInitialExpression() != null) {
                ListExpression oldArgs = (ListExpression)field.getInitialExpression();
                Iterator oldArgsIterator = oldArgs.getExpressions().iterator();
                while (oldArgsIterator.hasNext()) {
                    Expression exp = (Expression)oldArgsIterator.next();
                    args.addExpression(exp);
                }
            }
            field.setInitialValueExpression(null);
            block.add(new ExpressionStatement(new BinaryExpression(new FieldExpression(field), assign, new MethodCallExpression((Expression)new ClassExpression(enumClass), "$INIT", (Expression)args))));
        }
        block.add(new ExpressionStatement(new BinaryExpression(new FieldExpression(values), assign, new ArrayExpression(enumClass, arrayInit))));
        enumClass.addStaticInitializerStatements(block, true);
        enumClass.addField(values);
    }

    private void addConstructor(ClassNode enumClass) {
        ArrayList<ConstructorNode> ctors = new ArrayList<ConstructorNode>(enumClass.getDeclaredConstructors());
        if (ctors.size() == 0) {
            ConstructorNode init = new ConstructorNode(2, new Parameter[0], ClassNode.EMPTY_ARRAY, new BlockStatement());
            enumClass.addConstructor(init);
            ctors.add(init);
        }
        Iterator iterator = ctors.iterator();
        while (iterator.hasNext()) {
            ConstructorNode ctor = (ConstructorNode)iterator.next();
            if (ctor.firstStatementIsSpecialConstructorCall()) continue;
            Parameter[] oldP = ctor.getParameters();
            Parameter[] newP = new Parameter[oldP.length + 2];
            String stringParameterName = this.getUniqueVariableName("__str", ctor.getCode());
            newP[0] = new Parameter(ClassHelper.STRING_TYPE, stringParameterName);
            String intParameterName = this.getUniqueVariableName("__int", ctor.getCode());
            newP[1] = new Parameter(ClassHelper.int_TYPE, intParameterName);
            System.arraycopy(oldP, 0, newP, 2, oldP.length);
            ctor.setParameters(newP);
            ConstructorCallExpression cce = new ConstructorCallExpression(ClassNode.SUPER, new ArgumentListExpression(new VariableExpression(stringParameterName), new VariableExpression(intParameterName)));
            BlockStatement code = new BlockStatement();
            code.addStatement(new ExpressionStatement(cce));
            Statement oldCode = ctor.getCode();
            if (oldCode != null) {
                code.addStatement(oldCode);
            }
            ctor.setCode(code);
        }
    }

    private String getUniqueVariableName(final String name, Statement code) {
        if (code == null) {
            return name;
        }
        final Object[] found = new Object[1];
        CodeVisitorSupport cv = new CodeVisitorSupport(){

            public void visitVariableExpression(VariableExpression expression) {
                if (expression.getName().equals(name)) {
                    found[0] = Boolean.TRUE;
                }
            }
        };
        code.visit(cv);
        if (found[0] != null) {
            return this.getUniqueVariableName("_" + name, code);
        }
        return name;
    }
}

