/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.concurrent.locks;

import info.aduna.concurrent.locks.AbstractLock;
import info.aduna.concurrent.locks.Lock;
import info.aduna.concurrent.locks.Properties;
import java.lang.ref.WeakReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExclusiveLockManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean lockInUse = false;
    private boolean trackLocks;
    private WeakReference<Lock> activeLock;

    public ExclusiveLockManager() {
        this(false);
    }

    public ExclusiveLockManager(boolean trackLocks) {
        this.trackLocks = trackLocks || Properties.lockTrackingEnabled();
    }

    public synchronized Lock getExclusiveLock() throws InterruptedException {
        while (this.lockInUse) {
            this.wait();
        }
        this.lockInUse = true;
        AbstractLock lock = new AbstractLock(this.logger, this.trackLocks){

            protected void releaseLock() {
                ExclusiveLockManager.this.releaseExclusiveLock();
            }
        };
        if (this.trackLocks) {
            this.activeLock = new WeakReference<1>(lock);
        }
        return lock;
    }

    private synchronized void releaseExclusiveLock() {
        this.lockInUse = false;
        this.activeLock = null;
        this.notifyAll();
    }
}

