/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.api;

import info.bliki.api.Page;
import info.bliki.api.User;
import info.bliki.api.XMLPagesParser;
import info.bliki.api.XMLUserParser;
import info.bliki.api.query.Query;
import info.bliki.api.query.RequestBuilder;
import java.io.IOException;
import java.net.ProxySelector;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class Connector {
    protected static final String USER_AGENT = "JavaWikipediaAPI/3.1-SNAPSHOT https://bitbucket.org/axelclk/info.bliki.wiki/";
    private static final String PARAM_LOGIN_USERNAME = "lgusername";
    private static final String PARAM_LOGIN_NAME = "lgname";
    private static final String PARAM_LOGIN_USERID = "lguserid";
    private static final String PARAM_LOGIN_PASSWORD = "lgpassword";
    private static final String PARAM_LOGIN_TOKEN = "lgtoken";
    private static final String PARAM_LOGIN_DOMAIN = "lgdomain";
    private static final String PARAM_FORMAT = "format";
    private static final String PARAM_ACTION = "action";
    private static final String PARAM_TITLES = "titles";
    private static final String PARAM_CONTINUE = "continue";
    private static final String ACTION_LOGIN = "login";
    private static final String ACTION_QUERY = "query";
    private static final String FORMAT_XML = "xml";
    private static final String LINKS = "links";
    private static final String IMAGEINFO = "imageinfo";
    private static final String IIPROP = "iiprop";
    private static final String URL = "url";
    private static final String PROP = "prop";
    private static final String IIURLWIDTH = "iiurlwidth";
    private static final String CATEGORIES = "categories";
    private static final String REVISIONS = "revisions";
    private static final String RVPROP = "rvprop";
    private static final String INFO = "info";
    private HttpClient client;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static HttpClientBuilder DEFAULT_HTTPCLIENT_BUILDER = HttpClientBuilder.create().disableRedirectHandling().setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner(ProxySelector.getDefault()));

    public Connector() {
        this(DEFAULT_HTTPCLIENT_BUILDER);
    }

    public Connector(HttpClientBuilder builder) {
        this.client = builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User login(User user) {
        for (int i = 0; i < 2; ++i) {
            String userName = user.getUsername();
            if (userName == null || userName.trim().length() == 0) {
                return user;
            }
            HttpPost request = new HttpPost(user.getActionUrl());
            request.setHeader("User-Agent", USER_AGENT);
            String lgDomain = user.getDomain();
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.addAll(Arrays.asList(new BasicNameValuePair(PARAM_ACTION, ACTION_LOGIN), new BasicNameValuePair(PARAM_FORMAT, FORMAT_XML), new BasicNameValuePair(PARAM_LOGIN_NAME, userName), new BasicNameValuePair(PARAM_LOGIN_PASSWORD, user.getPassword())));
            if (lgDomain != null && lgDomain.length() > 0) {
                params.add(new BasicNameValuePair(PARAM_LOGIN_DOMAIN, lgDomain));
            }
            if (i > 0) {
                params.add(new BasicNameValuePair(PARAM_LOGIN_TOKEN, user.getToken()));
            }
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(params, (Charset)null));
            try {
                HttpResponse response = this.client.execute((HttpUriRequest)request);
                if (response.getStatusLine().getStatusCode() != 200) continue;
                String responseBody = Connector.getAsXmlString(response);
                XMLUserParser parser = new XMLUserParser(user, responseBody);
                parser.parse();
                if (i == 0 && "NeedToken".equals(user.getResult())) {
                    this.logger.debug("need_token_id");
                    continue;
                }
                if (!"Success".equals(user.getResult())) break;
                User user2 = user;
                return user2;
            }
            catch (IOException | SAXException e) {
                this.logger.error(null, (Throwable)e);
                continue;
            }
            finally {
                request.releaseConnection();
            }
        }
        this.logger.warn("could not log user in");
        return null;
    }

    public List<Page> queryContent(User user, List<String> listOfTitleStrings) {
        return this.query(user, listOfTitleStrings, PROP, REVISIONS, RVPROP, "timestamp|user|comment|content");
    }

    public List<Page> queryCategories(User user, List<String> listOfTitleStrings) {
        return this.query(user, listOfTitleStrings, PROP, CATEGORIES);
    }

    public List<Page> queryInfo(User user, List<String> listOfTitleStrings) {
        return this.query(user, listOfTitleStrings, PROP, INFO);
    }

    public List<Page> queryLinks(User user, List<String> listOfTitleStrings) {
        return this.query(user, listOfTitleStrings, PROP, LINKS);
    }

    public List<Page> queryImageinfo(User user, List<String> listOfImageStrings) {
        return this.query(user, listOfImageStrings, PROP, IMAGEINFO, IIPROP, URL);
    }

    public List<Page> queryImageinfo(User user, List<String> listOfImageStrings, int imageWidth) {
        return this.query(user, listOfImageStrings, PROP, IMAGEINFO, IIPROP, URL, IIURLWIDTH, Integer.toString(imageWidth));
    }

    public List<Page> query(User user, Query query) {
        String response = this.sendXML(user, query);
        try {
            return this.parsePageBody(response).getPagesList();
        }
        catch (IOException | SAXException e) {
            this.logger.error(null, (Throwable)e);
            return null;
        }
    }

    private List<Page> query(User user, List<String> listOfTitleStrings, String ... valuePairs) {
        try {
            String responseBody = this.queryXML(user, listOfTitleStrings, valuePairs);
            if (responseBody != null) {
                return this.parsePageBody(responseBody).getPagesList();
            }
        }
        catch (IOException | SAXException e) {
            this.logger.error(null, (Throwable)e);
        }
        return new ArrayList<Page>();
    }

    private String queryXML(User user, List<String> listOfTitleStrings, String[] valuePairs) {
        String titlesString = this.formatTitleString(listOfTitleStrings);
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair(PARAM_ACTION, ACTION_QUERY));
        parameters.add(new BasicNameValuePair(PARAM_CONTINUE, ""));
        if (titlesString.length() > 0) {
            parameters.add(new BasicNameValuePair(PARAM_TITLES, titlesString));
        }
        if (valuePairs != null && valuePairs.length > 0) {
            for (int i = 0; i < valuePairs.length; i += 2) {
                parameters.add(new BasicNameValuePair(valuePairs[i], valuePairs[i + 1]));
            }
        }
        return this.executeHttpMethod(this.createAuthenticatedRequest(user, parameters.toArray(new NameValuePair[parameters.size()])));
    }

    private String formatTitleString(List<String> titles) {
        StringBuilder titlesString = new StringBuilder();
        for (int i = 0; i < titles.size(); ++i) {
            titlesString.append(titles.get(i));
            if (i >= titles.size() - 1) continue;
            titlesString.append("|");
        }
        return titlesString.toString();
    }

    public String sendXML(User user, RequestBuilder requestBuilder) {
        return this.executeHttpMethod(this.createAuthenticatedRequest(user, requestBuilder.getParameters()));
    }

    private HttpRequestBase createAuthenticatedRequest(User user, NameValuePair[] parameters) {
        String actionUrl = user.getActionUrl();
        if (actionUrl == null || actionUrl.trim().length() == 0) {
            throw new IllegalArgumentException("no action url");
        }
        ArrayList<BasicNameValuePair> parameterList = new ArrayList<BasicNameValuePair>();
        parameterList.add(new BasicNameValuePair(PARAM_FORMAT, FORMAT_XML));
        Collections.addAll(parameterList, parameters);
        if (user.isAuthenticated()) {
            parameterList.addAll(Arrays.asList(new BasicNameValuePair(PARAM_LOGIN_USERNAME, user.getUserid()), new BasicNameValuePair(PARAM_LOGIN_USERID, user.getNormalizedUsername()), new BasicNameValuePair(PARAM_LOGIN_TOKEN, user.getToken())));
        }
        URIBuilder uriBuilder = new URIBuilder(URI.create(user.getActionUrl()));
        HttpGet request = new HttpGet(uriBuilder.addParameters(parameterList).toString());
        request.setHeader("User-Agent", USER_AGENT);
        return request;
    }

    private static String getAsXmlString(HttpResponse response) throws IOException {
        int index;
        ContentType type = ContentType.get((HttpEntity)response.getEntity());
        if (!type.getMimeType().startsWith("text/xml")) {
            throw new IOException("Invalid content-type: " + type);
        }
        String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
        if (responseBody.length() > 0 && responseBody.charAt(0) != '<' && (index = responseBody.indexOf("<?xml")) > 0) {
            responseBody = responseBody.substring(index);
        }
        return responseBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeHttpMethod(HttpRequestBase request) {
        try {
            HttpResponse response = this.client.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() == 200) {
                String string = Connector.getAsXmlString(response);
                return string;
            }
        }
        catch (IOException e) {
            this.logger.error("error fetching data", (Throwable)e);
        }
        finally {
            request.reset();
        }
        return null;
    }

    private XMLPagesParser parsePageBody(String responseBody) throws SAXException, IOException {
        XMLPagesParser parser = new XMLPagesParser(responseBody);
        parser.parse();
        List<String> warnings = parser.getWarnings();
        if (!warnings.isEmpty()) {
            this.logger.warn("parser warnings: " + warnings);
        }
        return parser;
    }
}

