/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.extensions.scribunto.engine.lua;

import info.bliki.extensions.scribunto.ScribuntoException;
import info.bliki.extensions.scribunto.engine.ScribuntoEngineBase;
import info.bliki.extensions.scribunto.engine.ScribuntoModule;
import info.bliki.extensions.scribunto.engine.lua.CompiledScriptCache;
import info.bliki.extensions.scribunto.engine.lua.ScribuntoLuaModule;
import info.bliki.extensions.scribunto.engine.lua.interfaces.MwHtml;
import info.bliki.extensions.scribunto.engine.lua.interfaces.MwInit;
import info.bliki.extensions.scribunto.engine.lua.interfaces.MwInterface;
import info.bliki.extensions.scribunto.engine.lua.interfaces.MwLanguage;
import info.bliki.extensions.scribunto.engine.lua.interfaces.MwMessage;
import info.bliki.extensions.scribunto.engine.lua.interfaces.MwSite;
import info.bliki.extensions.scribunto.engine.lua.interfaces.MwText;
import info.bliki.extensions.scribunto.engine.lua.interfaces.MwTitle;
import info.bliki.extensions.scribunto.engine.lua.interfaces.MwUri;
import info.bliki.extensions.scribunto.engine.lua.interfaces.MwUstring;
import info.bliki.extensions.scribunto.template.Frame;
import info.bliki.wiki.filter.MagicWord;
import info.bliki.wiki.filter.ParsedPageName;
import info.bliki.wiki.model.IWikiModel;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaClosure;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.ResourceFinder;
import org.luaj.vm2.lib.ThreeArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;
import org.luaj.vm2.lib.ZeroArgFunction;
import org.luaj.vm2.lib.jse.JsePlatform;

public class ScribuntoLuaEngine
extends ScribuntoEngineBase
implements MwInterface {
    private static final int MAX_EXPENSIVE_CALLS = 10;
    private static final boolean ENABLE_LUA_DEBUG_LIBRARY = false;
    private final Globals globals;
    private Frame currentFrame;
    private Map<String, Frame> childFrames = new HashMap<String, Frame>();
    private int expensiveFunctionCount;
    private final CompiledScriptCache compiledScriptCache;
    private final MwInterface[] interfaces;

    public ScribuntoLuaEngine(IWikiModel model, CompiledScriptCache cache) {
        this(model, cache, false);
    }

    public ScribuntoLuaEngine(IWikiModel model, CompiledScriptCache cache, boolean debug) {
        this(model, cache, debug ? JsePlatform.debugGlobals() : JsePlatform.standardGlobals());
    }

    private ScribuntoLuaEngine(IWikiModel model, CompiledScriptCache compiledScriptCache, Globals globals) {
        super(model);
        this.compiledScriptCache = compiledScriptCache;
        this.globals = globals;
        this.globals.finder = new LuaResourceFinder(globals.finder);
        this.extendGlobals(globals);
        this.interfaces = new MwInterface[]{new MwSite(model), new MwUstring(), new MwTitle(model), new MwText(), new MwUri(), new MwMessage(), new MwHtml(), new MwLanguage(model)};
        try {
            this.load();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ScribuntoModule fetchModuleFromParser(String moduleName) throws ScribuntoException {
        ParsedPageName pageName = this.pageNameForModule(moduleName);
        Prototype prototype = this.compiledScriptCache.getPrototypeForChunkname(pageName);
        if (prototype == null) {
            try (InputStream is = this.getRawWikiContentStream(pageName);){
                prototype = this.loadAndCache(is, pageName);
            }
            catch (IOException e) {
                throw new ScribuntoException(e);
            }
        }
        return new ScribuntoLuaModule(this, prototype, pageName);
    }

    @Override
    public String name() {
        return "mw";
    }

    protected Globals getGlobals() {
        return this.globals;
    }

    protected LuaValue loadFunction(String functionName, Prototype prototype, Frame frame) throws ScribuntoException {
        try {
            this.currentFrame = frame;
            LuaValue function = new LuaClosure(prototype, (LuaValue)this.globals).checkfunction().call().get(functionName);
            if (function.isnil()) {
                throw new ScribuntoException("no such function '" + functionName + "'");
            }
            LuaValue luaValue = function;
            return luaValue;
        }
        catch (LuaError e) {
            throw new ScribuntoException((Exception)((Object)e));
        }
        finally {
            this.currentFrame = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String executeFunctionChunk(LuaValue luaFunction, Frame frame) {
        this.assertFunction(luaFunction);
        try {
            this.currentFrame = frame;
            LuaValue executeFunction = this.globals.get("mw").get("executeFunction");
            this.logger.trace("executing " + luaFunction);
            LuaString result = executeFunction.call(luaFunction).checkstring();
            String string = new String(result.m_bytes, result.m_offset, result.m_length, UTF8);
            return string;
        }
        finally {
            this.currentFrame = null;
        }
    }

    private void assertFunction(LuaValue luaFunction) {
        if (luaFunction == null || luaFunction.isnil()) {
            throw new AssertionError((Object)"luaFunction is nil");
        }
    }

    private void load() throws IOException {
        this.load(new MwInit());
        this.load(this);
        for (MwInterface iface : this.interfaces) {
            this.load(iface);
        }
        this.stubTitleBlacklist();
        this.stubExecuteModule();
        this.stubWikiBase();
    }

    private void stubTitleBlacklist() {
        LuaValue mw = this.globals.get("mw");
        LuaValue ext = mw.get("ext");
        if (ext.isnil()) {
            ext = new LuaTable();
            mw.set("ext", ext);
        }
        LuaTable blacklist = new LuaTable();
        blacklist.set("test", (LuaValue)new TwoArgFunction(){

            public LuaValue call(LuaValue action, LuaValue title) {
                return NIL;
            }
        });
        ext.set("TitleBlacklist", (LuaValue)blacklist);
    }

    private void stubExecuteModule() {
        LuaValue mw = this.globals.get("mw");
        mw.set("executeModule", (LuaValue)new VarArgFunction(){

            public Varargs invoke(Varargs args) {
                LuaFunction chunk = args.arg(1).checkfunction();
                LuaValue name = args.arg(2);
                LuaValue res = chunk.call();
                if (name.isnil()) {
                    return LuaValue.varargsOf((LuaValue[])new LuaValue[]{LuaValue.TRUE, res});
                }
                if (!res.istable()) {
                    return LuaValue.varargsOf((LuaValue[])new LuaValue[]{FALSE, ScribuntoLuaEngine.toLuaString(res.typename())});
                }
                return LuaValue.varargsOf((LuaValue[])new LuaValue[]{LuaValue.TRUE, res.checktable().get(name)});
            }
        });
    }

    private void stubWikiBase() {
        LuaValue mw = this.globals.get("mw");
        LuaTable wikibase = new LuaTable();
        wikibase.set("getEntity", (LuaValue)new ZeroArgFunction(){

            public LuaValue call() {
                return NIL;
            }
        });
        wikibase.set("getEntityObject", (LuaValue)new ZeroArgFunction(){

            public LuaValue call() {
                return NIL;
            }
        });
        mw.set("wikibase", (LuaValue)wikibase);
    }

    private void load(MwInterface luaInterface) throws IOException {
        String filename = this.fileNameForInterface(luaInterface);
        try (InputStream is = this.globals.finder.findResource(filename);){
            if (is == null) {
                throw new FileNotFoundException("could not find '" + filename + "'. Make sure it is on the classpath.");
            }
            LuaValue pkg = this.globals.load(is, "@" + filename, "bt", (LuaValue)this.globals).call();
            LuaValue setupInterface = pkg.get("setupInterface");
            if (!setupInterface.isnil()) {
                this.globals.set("mw_interface", (LuaValue)luaInterface.getInterface());
                setupInterface.call(luaInterface.getSetupOptions());
            }
        }
    }

    @Override
    public LuaTable getInterface() {
        LuaTable table = new LuaTable();
        table.set("loadPackage", (LuaValue)this.loadPackage());
        table.set("loadPHPLibrary", (LuaValue)this.loadPHPLibrary());
        table.set("frameExists", this.frameExists());
        table.set("newChildFrame", this.newChildFrame());
        table.set("getExpandedArgument", this.getExpandedArgument());
        table.set("getAllExpandedArguments", this.getAllExpandedArguments());
        table.set("getFrameTitle", this.getFrameTitle());
        table.set("expandTemplate", this.expandTemplate());
        table.set("callParserFunction", this.callParserFunction());
        table.set("preprocess", this.preprocess());
        table.set("incrementExpensiveFunctionCount", this.incrementExpensiveFunctionCount());
        table.set("isSubsting", this.isSubsting());
        return table;
    }

    private String fileNameForInterface(MwInterface luaInterface) {
        return luaInterface.name() + (luaInterface.name().endsWith(".lua") ? "" : ".lua");
    }

    private LuaValue callParserFunction() {
        return new ThreeArgFunction(){

            public LuaValue call(LuaValue frameId, LuaValue function, LuaValue args) {
                String functionName = function.checkjstring();
                MagicWord.MagicWordE magic = MagicWord.getMagicWord(functionName);
                if (magic != null) {
                    String argument = args.optjstring(null);
                    String processed = MagicWord.processMagicWord(magic, argument, ScribuntoLuaEngine.this.model);
                    return ScribuntoLuaEngine.toLuaString(processed);
                }
                return NIL;
            }
        };
    }

    private LuaValue isSubsting() {
        return new ZeroArgFunction(){

            public LuaValue call() {
                return LuaValue.valueOf((boolean)ScribuntoLuaEngine.this.getFrameById((LuaValue)ScribuntoLuaEngine.toLuaString("current")).isSubsting());
            }
        };
    }

    private LuaValue incrementExpensiveFunctionCount() {
        return new ZeroArgFunction(){

            public LuaValue call() {
                if (++ScribuntoLuaEngine.this.expensiveFunctionCount > 10) {
                    7.error((String)"too many expensive function calls");
                }
                return NIL;
            }
        };
    }

    private LuaValue preprocess() {
        return new TwoArgFunction(){

            public LuaValue call(LuaValue frameId, LuaValue text) {
                try {
                    return ScribuntoLuaEngine.toLuaString(ScribuntoLuaEngine.this.model.render(text.checkjstring()));
                }
                catch (IOException e) {
                    ScribuntoLuaEngine.this.logger.error("error rendering", (Throwable)e);
                    return LuaValue.NIL;
                }
            }
        };
    }

    private LuaValue expandTemplate() {
        return new ThreeArgFunction(){

            public LuaValue call(LuaValue frameId, LuaValue title, LuaValue args) {
                Frame frame = ScribuntoLuaEngine.this.getFrameById(frameId);
                Map<String, String> parameterMap = frame.getTemplateParameters();
                parameterMap.putAll(ScribuntoLuaEngine.luaParams(args));
                StringWriter writer = new StringWriter();
                try {
                    ScribuntoLuaEngine.this.model.substituteTemplateCall(title.tojstring(), parameterMap, writer);
                    return ScribuntoLuaEngine.toLuaString(writer.toString());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private LuaValue getExpandedArgument() {
        return new TwoArgFunction(){

            public LuaValue call(LuaValue frameId, LuaValue name) {
                return ScribuntoLuaEngine.this.getFrameById(frameId).getArgument(name.tojstring());
            }
        };
    }

    private Frame getFrameById(LuaValue luaFrameId) {
        assert (this.currentFrame != null);
        String frameId = luaFrameId.checkjstring();
        Frame frame = null;
        if (frameId.equals("parent")) {
            frame = this.currentFrame.getParent();
        } else if (frameId.equals("current")) {
            frame = this.currentFrame;
        } else if (this.childFrames.containsKey(frameId)) {
            frame = this.childFrames.get(frameId);
        }
        if (frame == null) {
            throw new AssertionError((Object)("No frame set: " + luaFrameId));
        }
        return frame;
    }

    private LuaValue getFrameTitle() {
        return new OneArgFunction(){

            public LuaValue call(LuaValue arg) {
                return ScribuntoLuaEngine.toLuaString(ScribuntoLuaEngine.this.getFrameById(arg).getTitle());
            }
        };
    }

    private LuaValue getAllExpandedArguments() {
        return new OneArgFunction(){

            public LuaValue call(LuaValue frameId) {
                return ScribuntoLuaEngine.this.getFrameById(frameId).getAllArguments();
            }
        };
    }

    private LuaValue newChildFrame() {
        return new ThreeArgFunction(){

            public LuaValue call(LuaValue frameId, LuaValue title, LuaValue args) {
                Frame childFrame = ScribuntoLuaEngine.this.currentFrame.newChild(new ParsedPageName(((ScribuntoLuaEngine)ScribuntoLuaEngine.this).currentFrame.getPage().namespace, title.checkjstring(), true), ScribuntoLuaEngine.luaParams(args), ScribuntoLuaEngine.this.currentFrame.isSubsting());
                ScribuntoLuaEngine.this.childFrames.put(childFrame.getFrameId(), childFrame);
                return ScribuntoLuaEngine.toLuaString(childFrame.getFrameId());
            }
        };
    }

    private LuaValue frameExists() {
        return new OneArgFunction(){

            public LuaValue call(LuaValue arg) {
                return TRUE;
            }
        };
    }

    private OneArgFunction loadPackage() {
        return new OneArgFunction(){

            public LuaValue call(LuaValue packageName) {
                return ScribuntoLuaEngine.this.loadModule(ScribuntoLuaEngine.this.pageNameForModule(packageName.tojstring()));
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LuaValue loadModule(ParsedPageName chunkName) throws LuaError {
        Prototype prototype = this.compiledScriptCache.getPrototypeForChunkname(chunkName);
        if (prototype != null) {
            return new LuaClosure(prototype, (LuaValue)this.globals);
        }
        try (InputStream is = this.findPackage(chunkName);){
            LuaClosure luaClosure = new LuaClosure(this.loadAndCache(is, chunkName), (LuaValue)this.globals);
            return luaClosure;
        }
        catch (ScribuntoException | IOException e) {
            this.logger.error("error loading '" + chunkName + "'", (Throwable)e);
            throw new LuaError((Throwable)e);
        }
    }

    private Prototype loadAndCache(InputStream code, ParsedPageName chunkName) throws ScribuntoException {
        try {
            this.logger.debug("compiling " + chunkName);
            Prototype prototype = this.globals.compilePrototype(code, chunkName.fullPagename());
            this.compiledScriptCache.cachePrototype(chunkName, prototype);
            return prototype;
        }
        catch (IOException | LuaError e) {
            throw new ScribuntoException((Exception)e);
        }
    }

    private OneArgFunction loadPHPLibrary() {
        return new OneArgFunction(){

            public LuaValue call(LuaValue arg) {
                return LuaValue.NIL;
            }
        };
    }

    @Nonnull
    private InputStream findPackage(ParsedPageName name) throws IOException {
        this.logger.debug("findPackage(" + name + ")");
        InputStream is = this.globals.finder.findResource(name.pagename + ".lua");
        if (is != null) {
            return is;
        }
        return this.findModule(name);
    }

    private InputStream findModule(ParsedPageName moduleName) throws IOException {
        String name = moduleName.pagename.replaceAll("[/:]", "_");
        InputStream is = this.globals.finder.findResource(name);
        if (is != null) {
            return is;
        }
        return this.getRawWikiContentStream(moduleName);
    }

    @Override
    public LuaValue getSetupOptions() {
        return new LuaTable();
    }

    private void extendGlobals(final Globals globals) {
        globals.set("setfenv", (LuaValue)new TwoArgFunction(){

            public LuaValue call(LuaValue f, LuaValue env) {
                return f;
            }
        });
        globals.set("gefenv", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue f) {
                return globals;
            }
        });
        globals.set("unpack", (LuaValue)new unpack());
        LuaValue math = globals.get("math");
        math.set("log10", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue luaValue) {
                return 19.valueOf((double)Math.log10(luaValue.checkdouble()));
            }
        });
        math.set("mod", math.get("modf"));
        LuaValue table = globals.get("table");
        table.set("maxn", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue arg) {
                return arg.checktable().len();
            }
        });
        table.set("getn", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue arg) {
                if (arg.isnil()) {
                    return LuaValue.error((String)"bad argument #1 to 'getn' (table expected, got nil)");
                }
                return arg.checktable().len();
            }
        });
    }

    public static LuaString toLuaString(String string) {
        return LuaString.valueOf((byte[])string.getBytes(UTF8));
    }

    private static Map<String, String> luaParams(LuaValue args) {
        Varargs next;
        HashMap<String, String> parameters = new HashMap<String, String>();
        LuaTable table = args.checktable();
        LuaValue key = LuaValue.NIL;
        while (!(key = (next = table.next(key)).arg1()).isnil()) {
            LuaValue value = next.arg(2);
            parameters.put(key.checkjstring(), value.checkjstring());
        }
        return parameters;
    }

    static class LuaResourceFinder
    implements ResourceFinder {
        private static final String[] LIBRARY_PATH = new String[]{"", "luabit", "ustring"};
        private final ResourceFinder delegate;

        LuaResourceFinder(ResourceFinder delegate) {
            this.delegate = delegate;
        }

        public InputStream findResource(String filename) {
            for (String path : LIBRARY_PATH) {
                InputStream is = this.delegate.findResource(path + "/" + filename);
                if (is == null) continue;
                return is;
            }
            return null;
        }
    }

    private static class unpack
    extends VarArgFunction {
        private unpack() {
        }

        public Varargs invoke(Varargs args) {
            LuaTable t = args.checktable(1);
            switch (args.narg()) {
                case 1: {
                    return t.unpack();
                }
                case 2: {
                    return t.unpack(args.checkint(2));
                }
            }
            return t.unpack(args.checkint(2), args.checkint(3));
        }
    }
}

