/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.extensions.scribunto.engine.lua.interfaces;

import info.bliki.extensions.scribunto.engine.lua.ScribuntoLuaEngine;
import info.bliki.extensions.scribunto.engine.lua.interfaces.Languages;
import info.bliki.extensions.scribunto.engine.lua.interfaces.MwInterface;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.template.dates.StringToTime;
import java.util.Date;
import java.util.Locale;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.ThreeArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.ZeroArgFunction;

public class MwLanguage
implements MwInterface {
    private Languages languages = new Languages();
    private final IWikiModel wikiModel;

    public MwLanguage(IWikiModel wikiModel) {
        this.wikiModel = wikiModel;
    }

    @Override
    public String name() {
        return "mw.language";
    }

    @Override
    public LuaTable getInterface() {
        LuaTable table = new LuaTable();
        table.set("isSupportedLanguage", (LuaValue)MwInterface.DefaultFunction.defaultFunction());
        table.set("isKnownLanguageTag", this.isKnownLanguageTag());
        table.set("isValidCode", (LuaValue)MwInterface.DefaultFunction.defaultFunction());
        table.set("isValidBuiltInCode", (LuaValue)MwInterface.DefaultFunction.defaultFunction());
        table.set("fetchLanguageName", this.fetchLanguageName());
        table.set("fetchLanguageNames", this.fetchLanguageNames());
        table.set("getFallbacksFor", (LuaValue)MwInterface.DefaultFunction.defaultFunction());
        table.set("getContLangCode", this.getContLangCode());
        table.set("formatDate", this.formatDate());
        table.set("lc", this.lc());
        table.set("uc", this.uc());
        table.set("lcfirst", this.lcfirst());
        table.set("ucfirst", this.ucfirst());
        return table;
    }

    private LuaValue lcfirst() {
        return new TwoArgFunction(){

            public LuaValue call(LuaValue lang, LuaValue string) {
                Locale locale = MwLanguage.getLocale(lang);
                String input = string.checkjstring();
                switch (input.length()) {
                    case 0: {
                        return string;
                    }
                    case 1: {
                        return ScribuntoLuaEngine.toLuaString(input.toLowerCase(locale));
                    }
                }
                return ScribuntoLuaEngine.toLuaString(input.substring(0, 1).toLowerCase(locale) + input.substring(1));
            }
        };
    }

    private LuaValue ucfirst() {
        return new TwoArgFunction(){

            public LuaValue call(LuaValue lang, LuaValue string) {
                Locale locale = MwLanguage.getLocale(lang);
                String input = string.checkjstring();
                switch (input.length()) {
                    case 0: {
                        return string;
                    }
                    case 1: {
                        return ScribuntoLuaEngine.toLuaString(input.toUpperCase(locale));
                    }
                }
                return ScribuntoLuaEngine.toLuaString(input.substring(0, 1).toUpperCase(locale) + input.substring(1));
            }
        };
    }

    private LuaValue formatDate() {
        return new ThreeArgFunction(){

            public LuaValue call(LuaValue lang, LuaValue format, LuaValue date) {
                Date time;
                String formatString = format.checkjstring();
                String dateString = date.checkjstring();
                Date date2 = time = dateString.isEmpty() ? MwLanguage.this.wikiModel.getCurrentTimeStamp() : (Date)StringToTime.date(dateString);
                if ("U".equals(formatString)) {
                    return ScribuntoLuaEngine.toLuaString(String.valueOf(time.getTime() / 1000L));
                }
                throw new UnsupportedOperationException();
            }
        };
    }

    private LuaValue lc() {
        return new TwoArgFunction(){

            public LuaValue call(LuaValue code, LuaValue string) {
                return ScribuntoLuaEngine.toLuaString(string.checkjstring().toLowerCase(MwLanguage.getLocale(code)));
            }
        };
    }

    private LuaValue uc() {
        return new TwoArgFunction(){

            public LuaValue call(LuaValue code, LuaValue string) {
                return ScribuntoLuaEngine.toLuaString(string.checkjstring().toUpperCase(MwLanguage.getLocale(code)));
            }
        };
    }

    public LuaValue isKnownLanguageTag() {
        return new OneArgFunction(){

            public LuaValue call(LuaValue code) {
                return LuaValue.TRUE;
            }
        };
    }

    private LuaValue fetchLanguageNames() {
        return new TwoArgFunction(){

            public LuaValue call(LuaValue inLanguage, LuaValue include) {
                return new LuaTable();
            }
        };
    }

    private LuaValue fetchLanguageName() {
        return new TwoArgFunction(){

            public LuaValue call(LuaValue code, LuaValue inLanguage) {
                String name = MwLanguage.this.languages.getName(code.checkjstring(), inLanguage.optjstring(null));
                return name == null ? NIL : ScribuntoLuaEngine.toLuaString(name);
            }
        };
    }

    private LuaValue getContLangCode() {
        return new ZeroArgFunction(){

            public LuaValue call() {
                return ScribuntoLuaEngine.toLuaString("en");
            }
        };
    }

    @Override
    public LuaValue getSetupOptions() {
        return null;
    }

    static Locale getLocale(LuaValue value) {
        Locale locale = Locale.forLanguageTag(value.checkjstring());
        if (locale.getLanguage().isEmpty()) {
            LuaValue.error((String)String.format("language code '%s' is invalid", value.checkstring()));
        }
        return locale;
    }
}

