/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.extensions.scribunto.engine.lua.interfaces;

import info.bliki.extensions.scribunto.engine.lua.ScribuntoLuaEngine;
import info.bliki.extensions.scribunto.engine.lua.interfaces.MwInterface;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.namespaces.INamespace;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.LibFunction;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;

public class MwTitle
implements MwInterface {
    private final IWikiModel wikiModel;

    public MwTitle(IWikiModel wikiModel) {
        assert (wikiModel != null);
        this.wikiModel = wikiModel;
    }

    @Override
    public String name() {
        return "mw.title";
    }

    @Override
    public LuaTable getInterface() {
        LuaTable table = new LuaTable();
        table.set("newTitle", this.newTitle());
        table.set("makeTitle", this.makeTitle());
        table.set("getExpensiveData", this.getExpensiveData());
        table.set("getUrl", this.getUrl());
        table.set("getContent", this.getContent());
        table.set("fileExists", this.fileExists());
        table.set("getFileInfo", this.getFileInfo());
        table.set("protectionLevels", this.protectionLevels());
        table.set("cascadingProtection", this.cascadingProtection());
        return table;
    }

    @Override
    public LuaValue getSetupOptions() {
        LuaTable table = new LuaTable();
        table.set("thisTitle", this.title(this.wikiModel.getNamespaceName(), this.wikiModel.getPageName()));
        table.set("NS_MEDIA", INamespace.NamespaceCode.MEDIA_NAMESPACE_KEY.code.intValue());
        return table;
    }

    private LuaValue getFileInfo() {
        return new OneArgFunction(){

            public LuaValue call(LuaValue arg) {
                return LuaValue.NIL;
            }
        };
    }

    private LuaValue getExpensiveData() {
        return new OneArgFunction(){

            public LuaValue call(LuaValue arg) {
                return new LuaTable();
            }
        };
    }

    private LuaValue getUrl() {
        return new LibFunction(){

            public Varargs invoke(Varargs args) {
                return LuaValue.EMPTYSTRING;
            }
        };
    }

    private LuaValue fileExists() {
        return new OneArgFunction(){

            public LuaValue call(LuaValue page) {
                return NIL;
            }
        };
    }

    private LuaValue protectionLevels() {
        return new OneArgFunction(){

            public LuaValue call(LuaValue action) {
                return new LuaTable();
            }
        };
    }

    private LuaValue cascadingProtection() {
        return new OneArgFunction(){

            public LuaValue call(LuaValue action) {
                LuaTable table = new LuaTable();
                table.set("restrictions", (LuaValue)new LuaTable());
                return table;
            }
        };
    }

    private LuaValue getContent() {
        return new OneArgFunction(){

            public LuaValue call(LuaValue page) {
                return NIL;
            }
        };
    }

    private LuaValue newTitle() {
        return new TwoArgFunction(){

            public LuaValue call(LuaValue text_or_id, LuaValue defaultNamespace) {
                return MwTitle.this.title(defaultNamespace, text_or_id, (LuaValue)ScribuntoLuaEngine.toLuaString("fragment"), (LuaValue)ScribuntoLuaEngine.toLuaString("interwiki"));
            }
        };
    }

    private LuaValue makeTitle() {
        return new LibFunction(){

            public Varargs invoke(Varargs args) {
                LuaValue ns = args.arg(1);
                LuaValue title = args.arg(2);
                LuaValue fragment = args.arg(3);
                LuaValue interwiki = args.arg(4);
                return MwTitle.this.title(ns, title, fragment, interwiki);
            }
        };
    }

    private LuaValue title(String namespace, String pageName) {
        return this.title((LuaValue)ScribuntoLuaEngine.toLuaString(namespace != null ? namespace : ""), (LuaValue)ScribuntoLuaEngine.toLuaString(pageName != null ? pageName : ""), LuaValue.NIL, LuaValue.NIL);
    }

    private LuaValue title(LuaValue ns, LuaValue title, LuaValue fragment, LuaValue interwiki) {
        LuaTable table = new LuaTable();
        table.set("isLocal", (LuaValue)LuaValue.EMPTYSTRING);
        table.set("isRedirect", (LuaValue)LuaValue.EMPTYSTRING);
        table.set("subjectNsText", (LuaValue)LuaValue.EMPTYSTRING);
        table.set("interwiki", (LuaValue)(interwiki.isnil() ? LuaValue.EMPTYSTRING : interwiki));
        table.set("namespace", (LuaValue)LuaValue.valueOf((int)INamespace.NamespaceCode.MAIN_NAMESPACE_KEY.code));
        table.set("nsText", (LuaValue)(ns.isnil() ? LuaValue.EMPTYSTRING : ns));
        table.set("text", title);
        table.set("id", title);
        table.set("fragment", (LuaValue)(fragment.isnil() ? LuaValue.EMPTYSTRING : fragment));
        table.set("contentModel", (LuaValue)LuaValue.EMPTYSTRING);
        table.set("thePartialUrl", (LuaValue)LuaValue.EMPTYSTRING);
        return table;
    }
}

