/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.filter;

import info.bliki.htmlcleaner.ContentToken;
import info.bliki.htmlcleaner.TagNode;
import info.bliki.htmlcleaner.TagToken;
import info.bliki.wiki.filter.AbstractParser;
import info.bliki.wiki.filter.ParsedPageName;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.namespaces.INamespace;
import info.bliki.wiki.tags.HTMLTag;
import info.bliki.wiki.tags.WPBoldItalicTag;
import info.bliki.wiki.tags.WPTag;
import info.bliki.wiki.tags.util.TagStack;
import java.util.Map;

public abstract class AbstractWikipediaParser
extends AbstractParser {
    protected static final int TokenIgnore = -1;
    protected static final int TokenSTART = 0;
    protected static final int TokenEOF = 1;
    protected static final int TokenBOLD = 3;
    protected static final int TokenITALIC = 4;
    protected static final int TokenBOLDITALIC = 5;
    protected static final HTMLTag BOLD = new WPTag("b");
    protected static final HTMLTag ITALIC = new WPTag("i");
    protected static final HTMLTag BOLDITALIC = new WPBoldItalicTag();

    public AbstractWikipediaParser(String stringSource) {
        super(stringSource);
    }

    public abstract void runParser();

    protected abstract void setNoToC(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRedirectedRawContent(IWikiModel wikiModel, ParsedPageName parsedPagename, Map<String, String> templateParameters) {
        try {
            int level = wikiModel.incrementRecursionLevel();
            if (level > 256 || !parsedPagename.valid) {
                String string = "<span class=\"error\">Error - getting content of redirected link: " + parsedPagename.namespace + ":" + parsedPagename.pagename + "<span>";
                return string;
            }
            String string = wikiModel.getRawWikiContent(parsedPagename, templateParameters);
            return string;
        }
        finally {
            wikiModel.decrementRecursionLevel();
        }
    }

    protected static String getRedirectedTemplateContent(IWikiModel wikiModel, String redirectedLink, Map<String, String> templateParameters) {
        INamespace namespace = wikiModel.getNamespace();
        ParsedPageName parsedPagename = ParsedPageName.parsePageName(wikiModel, redirectedLink, namespace.getMain(), false, false);
        if (!parsedPagename.valid) {
            return null;
        }
        return AbstractWikipediaParser.getRedirectedRawContent(wikiModel, parsedPagename, templateParameters);
    }

    protected void reduceTokenStack() {
        while (this.fWikiModel.stackSize() > 0) {
            this.fWikiModel.popNode();
        }
    }

    protected void createContentToken(int diff) {
        if (this.fWhiteStart) {
            try {
                int count = this.fCurrentPosition - diff - this.fWhiteStartPosition;
                if (count > 0) {
                    this.fWikiModel.append(new ContentToken(this.fStringSource.substring(this.fWhiteStartPosition, this.fWhiteStartPosition + count)));
                }
            }
            finally {
                this.fWhiteStart = false;
            }
        }
    }

    protected boolean parseHTMLCommentTags() {
        if (this.fStringSource.startsWith("<!--", this.fCurrentPosition - 1)) {
            int htmlStartPosition = this.fCurrentPosition;
            this.fCurrentPosition += 3;
            this.readUntil("-->");
            this.createContentToken(this.fCurrentPosition - htmlStartPosition + 1);
            return true;
        }
        return false;
    }

    protected void reduceTokenStackBoldItalic() {
        boolean found = false;
        while (this.fWikiModel.stackSize() > 0) {
            TagToken token = this.fWikiModel.peekNode();
            if (token.equals(BOLD) || token.equals(ITALIC) || token.equals(BOLDITALIC)) {
                if (this.fWhiteStart) {
                    found = true;
                    this.createContentToken(1);
                }
                this.fWikiModel.popNode();
                continue;
            }
            return;
        }
        if (found) {
            this.fWhiteStart = true;
            this.fWhiteStartPosition = this.fCurrentPosition;
        }
    }

    protected void reduceStackUntilToken(TagToken node) {
        int index = -1;
        String allowedParents = node.getParents();
        while (this.fWikiModel.stackSize() > 0) {
            TagToken tag = this.fWikiModel.peekNode();
            if (node.getName().equals(tag.getName())) {
                this.fWikiModel.popNode();
                break;
            }
            if (allowedParents == null) {
                this.fWikiModel.popNode();
                continue;
            }
            index = allowedParents.indexOf("|" + tag.getName() + "|");
            if (index >= 0) break;
            this.fWikiModel.popNode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TagStack parseRecursiveInternal(IWikiModel wikiModel, boolean createOnlyLocalStack, boolean noTOC) {
        TagStack localStack = new TagStack();
        TagStack globalWikiModelStack = wikiModel.swapStack(localStack);
        try {
            int level = wikiModel.incrementRecursionLevel();
            if (level > 256) {
                TagNode error = new TagNode("span");
                error.addAttribute("class", "error", true);
                error.addChild(new ContentToken("Error - recursion limit exceeded parsing wiki tags."));
                localStack.append(error);
                TagStack tagStack = localStack;
                return tagStack;
            }
            this.setModel(wikiModel);
            this.setNoToC(noTOC);
            this.runParser();
            TagStack error = localStack;
            return error;
        }
        catch (Error | Exception e) {
            e.printStackTrace();
            TagNode error = new TagNode("span");
            error.addAttribute("class", "error", true);
            error.addChild(new ContentToken(e.getClass().getSimpleName()));
            localStack.append(error);
        }
        finally {
            wikiModel.decrementRecursionLevel();
            if (!createOnlyLocalStack) {
                globalWikiModelStack.append(localStack);
            }
            wikiModel.swapStack(globalWikiModelStack);
        }
        return localStack;
    }
}

