/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.filter;

import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.namespaces.INamespace;
import info.bliki.wiki.template.Titleparts;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class MagicWord {
    protected static final HashMap<String, MagicWordE> MAGIC_WORDS = new HashMap(100);

    public static boolean isMagicWord(String name) {
        return MAGIC_WORDS.containsKey(name.toLowerCase());
    }

    public static MagicWordE getMagicWord(String name) {
        return MagicWordE.fromString(name);
    }

    public static String processMagicWord(MagicWordE magicWord, String parameter, IWikiModel model) {
        assert (magicWord != null);
        SimpleDateFormat formatter = model.getSimpleDateFormat();
        Date current = model.getCurrentTimeStamp();
        if (current == null) {
            current = new Date(System.currentTimeMillis());
        }
        Date revision = current;
        switch (magicWord) {
            case MAGIC_LOCAL_DAY: {
                formatter.applyPattern("d");
                return formatter.format(current);
            }
            case MAGIC_LOCAL_DAY2: {
                formatter.applyPattern("dd");
                return formatter.format(current);
            }
            case MAGIC_LOCAL_DAY_NAME: {
                formatter.applyPattern("EEEE");
                return formatter.format(current);
            }
            case MAGIC_LOCAL_DAY_OF_WEEK: {
                formatter.applyPattern("F");
                return formatter.format(current);
            }
            case MAGIC_LOCAL_MONTH: {
                formatter.applyPattern("MM");
                return formatter.format(current);
            }
            case MAGIC_LOCAL_MONTH_ABBR: {
                formatter.applyPattern("MMM");
                return formatter.format(current);
            }
            case MAGIC_LOCAL_MONTH_NAME: {
                formatter.applyPattern("MMMM");
                return formatter.format(current);
            }
            case MAGIC_LOCAL_TIME: {
                formatter.applyPattern("HH:mm");
                return formatter.format(current);
            }
            case MAGIC_LOCAL_HOUR: {
                formatter.applyPattern("HH");
                return formatter.format(current);
            }
            case MAGIC_LOCAL_WEEK: {
                formatter.applyPattern("w");
                return formatter.format(current);
            }
            case MAGIC_LOCAL_YEAR: {
                formatter.applyPattern("yyyy");
                return formatter.format(current);
            }
            case MAGIC_LOCAL_TIMESTAMP: {
                formatter.applyPattern("yyyyMMddHHmmss");
                return formatter.format(current);
            }
            case MAGIC_CURRENT_DAY: {
                formatter.applyPattern("d");
                return formatter.format(current);
            }
            case MAGIC_CURRENT_DAY2: {
                formatter.applyPattern("dd");
                return formatter.format(current);
            }
            case MAGIC_CURRENT_DAY_NAME: {
                formatter.applyPattern("EEEE");
                return formatter.format(current);
            }
            case MAGIC_CURRENT_DAY_OF_WEEK: {
                formatter.applyPattern("F");
                return formatter.format(current);
            }
            case MAGIC_CURRENT_MONTH: {
                formatter.applyPattern("MM");
                return formatter.format(current);
            }
            case MAGIC_CURRENT_MONTH_ABBR: {
                formatter.applyPattern("MMM");
                return formatter.format(current);
            }
            case MAGIC_CURRENT_MONTH_NAME: {
                formatter.applyPattern("MMMM");
                return formatter.format(current);
            }
            case MAGIC_CURRENT_TIME: {
                formatter.applyPattern("HH:mm");
                return formatter.format(current);
            }
            case MAGIC_CURRENT_HOUR: {
                formatter.applyPattern("HH");
                return formatter.format(current);
            }
            case MAGIC_CURRENT_WEEK: {
                formatter.applyPattern("w");
                return formatter.format(current);
            }
            case MAGIC_CURRENT_YEAR: {
                formatter.applyPattern("yyyy");
                return formatter.format(current);
            }
            case MAGIC_CURRENT_TIMESTAMP: {
                formatter.applyPattern("yyyyMMddHHmmss");
                return formatter.format(current);
            }
            case MAGIC_REVISION_YEAR: {
                formatter.applyPattern("yyyy");
                return formatter.format(revision);
            }
            case MAGIC_REVISION_DAY: {
                formatter.applyPattern("d");
                return formatter.format(revision);
            }
            case MAGIC_REVISION_DAY2: {
                formatter.applyPattern("dd");
                return formatter.format(revision);
            }
            case MAGIC_REVISION_MONTH: {
                formatter.applyPattern("MM");
                return formatter.format(revision);
            }
            case MAGIC_REVISION_MONTH1: {
                formatter.applyPattern("M");
                return formatter.format(revision);
            }
            case MAGIC_REVISION_TIMESTAMP: {
                formatter.applyPattern("yyyyMMddHHmmss");
                return formatter.format(revision);
            }
            case MAGIC_REVISION_USER: {
                return "";
            }
            case MAGIC_PAGE_NAME: {
                String pagename = MagicWord.getPagenameHelper(parameter, model);
                if (pagename != null) {
                    return pagename;
                }
                return "";
            }
            case MAGIC_PAGE_NAME_E: {
                String pagename = MagicWord.getPagenameHelper(parameter, model);
                if (pagename != null) {
                    return model.encodeTitleToUrl(pagename, true);
                }
                return "";
            }
            case MAGIC_NAMESPACE: {
                return MagicWord.getNamespace(parameter, model);
            }
            case MAGIC_NAMESPACE_E: {
                return model.encodeTitleToUrl(MagicWord.getNamespace(parameter, model), true);
            }
            case MAGIC_NAMESPACENUMBER: {
                INamespace.INamespaceValue namespaceHelper = MagicWord.getNamespaceHelper(parameter, model);
                if (namespaceHelper != null) {
                    return namespaceHelper.getCode().code.toString();
                }
                return null;
            }
            case MAGIC_TALK_SPACE: {
                return MagicWord.getTalkspace(parameter, model);
            }
            case MAGIC_TALK_SPACE_E: {
                return model.encodeTitleToUrl(MagicWord.getTalkspace(parameter, model), true);
            }
            case MAGIC_SUBJECT_SPACE: 
            case MAGIC_ARTICLE_SPACE: {
                return MagicWord.getSubjectSpace(parameter, model);
            }
            case MAGIC_SUBJECT_SPACE_E: 
            case MAGIC_ARTICLE_SPACE_E: {
                return model.encodeTitleToUrl(MagicWord.getSubjectSpace(parameter, model), true);
            }
            case MAGIC_FULL_PAGE_NAME: {
                return MagicWord.getFullpagename(parameter, model);
            }
            case MAGIC_FULL_PAGE_NAME_E: {
                return model.encodeTitleToUrl(MagicWord.getFullpagename(parameter, model), true);
            }
            case MAGIC_FULL_URL: {
                return MagicWord.fullUrl(model, parameter, false);
            }
            case MAGIC_FULL_URL_E: {
                return MagicWord.fullUrl(model, parameter, true);
            }
            case MAGIC_TALK_PAGE_NAME: {
                return MagicWord.getTalkpage(parameter, model);
            }
            case MAGIC_TALK_PAGE_NAME_E: {
                return model.encodeTitleToUrl(MagicWord.getTalkpage(parameter, model), true);
            }
            case MAGIC_SUBJECT_PAGE_NAME: 
            case MAGIC_ARTICLE_PAGE_NAME: {
                return MagicWord.getSubjectpage(parameter, model);
            }
            case MAGIC_SUBJECT_PAGE_NAME_E: 
            case MAGIC_ARTICLE_PAGE_NAME_E: {
                return model.encodeTitleToUrl(MagicWord.getSubjectpage(parameter, model), true);
            }
            case MAGIC_BASE_PAGE_NAME: {
                return MagicWord.getBasePageName(parameter, model);
            }
            case MAGIC_BASE_PAGE_NAME_E: {
                return model.encodeTitleToUrl(MagicWord.getBasePageName(parameter, model), true);
            }
            case MAGIC_SUB_PAGE_NAME: {
                return MagicWord.getSubPageName(parameter, model);
            }
            case MAGIC_SUB_PAGE_NAME_E: {
                return model.encodeTitleToUrl(MagicWord.getSubPageName(parameter, model), false);
            }
            case MAGIC_BANG: {
                return "|";
            }
        }
        return magicWord.toString();
    }

    protected static String getSubPageName(String parameter, IWikiModel model) {
        String pagename = MagicWord.getPagenameHelper(parameter, model);
        if (pagename != null) {
            return Titleparts.getTitleparts(pagename, 0, -1);
        }
        return "";
    }

    protected static String getBasePageName(String parameter, IWikiModel model) {
        String pagename = MagicWord.getPagenameHelper(parameter, model);
        if (pagename != null) {
            String basePagename = Titleparts.getTitleparts(pagename, -1, 1);
            if (pagename.length() != 0 && basePagename.length() == 0) {
                return pagename;
            }
            return basePagename;
        }
        return "";
    }

    protected static String getFullpagename(String parameter, IWikiModel model) {
        String[] fullPage = MagicWord.getPagenameHelper2(parameter, model);
        if (fullPage != null) {
            INamespace.INamespaceValue namespace = model.getNamespace().getNamespace(fullPage[0]);
            if (namespace == null) {
                return fullPage[1];
            }
            return namespace.makeFullPagename(fullPage[1]);
        }
        return "";
    }

    private static String fullUrl(IWikiModel model, String parameter, boolean encode) {
        String name = MagicWord.getFullpagename(parameter, model);
        return model.getWikiBaseURL().replace("${title}", encode ? model.encodeTitleToUrl(name, true) : name).replaceAll("^https?:", "");
    }

    protected static String getSubjectpage(String parameter, IWikiModel model) {
        String[] fullPage = MagicWord.getPagenameHelper2(parameter, model);
        if (fullPage != null) {
            INamespace.INamespaceValue subjectSpace = model.getNamespace().getContentspace(fullPage[0]);
            if (subjectSpace == null) {
                return fullPage[1];
            }
            return subjectSpace.makeFullPagename(fullPage[1]);
        }
        return "";
    }

    protected static String getTalkpage(String parameter, IWikiModel model) {
        String[] fullPage = MagicWord.getPagenameHelper2(parameter, model);
        if (fullPage != null) {
            INamespace.INamespaceValue talkSpace = model.getNamespace().getTalkspace(fullPage[0]);
            if (talkSpace == null) {
                return fullPage[1];
            }
            return talkSpace.makeFullPagename(fullPage[1]);
        }
        return "";
    }

    protected static String getTalkspace(String parameter, IWikiModel model) {
        INamespace.INamespaceValue namespace = MagicWord.getNamespaceHelper(parameter, model);
        if (namespace != null) {
            return namespace.getTalkspace().toString();
        }
        return "";
    }

    protected static String getSubjectSpace(String parameter, IWikiModel model) {
        INamespace.INamespaceValue namespace = MagicWord.getNamespaceHelper(parameter, model);
        if (namespace != null) {
            return namespace.getContentspace().toString();
        }
        return "";
    }

    protected static String getNamespace(String parameter, IWikiModel model) {
        INamespace.INamespaceValue namespace = MagicWord.getNamespaceHelper(parameter, model);
        if (namespace != null) {
            return namespace.toString();
        }
        return "";
    }

    protected static INamespace.INamespaceValue getNamespaceHelper(String parameter, IWikiModel model) {
        INamespace namespaceObj = model.getNamespace();
        if (parameter != null) {
            if (parameter.length() > 0) {
                String[] split = model.splitNsTitle(parameter);
                return namespaceObj.getNamespace(split[0]);
            }
            return null;
        }
        return namespaceObj.getNamespace(model.getNamespaceName());
    }

    protected static String getPagenameHelper(String parameter, IWikiModel model) {
        if (parameter != null) {
            if (parameter.length() > 0) {
                String[] split = model.splitNsTitle(parameter);
                return split[1];
            }
            return null;
        }
        return model.getPageName();
    }

    protected static String[] getPagenameHelper2(String parameter, IWikiModel model) {
        if (parameter != null) {
            if (parameter.length() > 0) {
                return model.splitNsTitle(parameter);
            }
            return null;
        }
        return new String[]{model.getNamespace().getNamespace(model.getNamespaceName()).toString(), model.getPageName()};
    }

    public static enum MagicWordE {
        MAGIC_CURRENT_DAY("CURRENTDAY"),
        MAGIC_CURRENT_DAY2("CURRENTDAY2"),
        MAGIC_CURRENT_DAY_NAME("CURRENTDAYNAME"),
        MAGIC_CURRENT_DAY_OF_WEEK("CURRENTDOW"),
        MAGIC_CURRENT_MONTH("CURRENTMONTH"),
        MAGIC_CURRENT_MONTH_ABBR("CURRENTMONTHABBREV"),
        MAGIC_CURRENT_MONTH_NAME("CURRENTMONTHNAME"),
        MAGIC_CURRENT_TIME("CURRENTTIME"),
        MAGIC_CURRENT_HOUR("CURRENTHOUR"),
        MAGIC_CURRENT_WEEK("CURRENTWEEK"),
        MAGIC_CURRENT_YEAR("CURRENTYEAR"),
        MAGIC_CURRENT_TIMESTAMP("CURRENTTIMESTAMP"),
        MAGIC_LOCAL_DAY("LOCALDAY"),
        MAGIC_LOCAL_DAY2("LOCALDAY2"),
        MAGIC_LOCAL_DAY_NAME("LOCALDAYNAME"),
        MAGIC_LOCAL_DAY_OF_WEEK("LOCALDOW"),
        MAGIC_LOCAL_MONTH("LOCALMONTH"),
        MAGIC_LOCAL_MONTH_ABBR("LOCALMONTHABBREV"),
        MAGIC_LOCAL_MONTH_NAME("LOCALMONTHNAME"),
        MAGIC_LOCAL_TIME("LOCALTIME"),
        MAGIC_LOCAL_HOUR("LOCALHOUR"),
        MAGIC_LOCAL_WEEK("LOCALWEEK"),
        MAGIC_LOCAL_YEAR("LOCALYEAR"),
        MAGIC_LOCAL_TIMESTAMP("LOCALTIMESTAMP"),
        MAGIC_CURRENT_VERSION("CURRENTVERSION"),
        MAGIC_NUMBER_ARTICLES("NUMBEROFARTICLES"),
        MAGIC_NUMBER_PAGES("NUMBEROFPAGES"),
        MAGIC_NUMBER_FILES("NUMBEROFFILES"),
        MAGIC_NUMBER_USERS("NUMBEROFUSERS"),
        MAGIC_NUMBER_ADMINS("NUMBEROFADMINS"),
        MAGIC_PAGES_IN_CATEGORY("PAGESINCATEGORY"),
        MAGIC_PAGES_IN_CAT("PAGESINCAT"),
        MAGIC_PAGES_IN_NAMESPACE("PAGESINNAMESPACE"),
        MAGIC_PAGES_IN_NAMESPACE_NS("PAGESINNS"),
        MAGIC_PAGE_SIZE("PAGESIZE"),
        MAGIC_PAGE_NAME("PAGENAME"),
        MAGIC_PAGE_NAME_E("PAGENAMEE"),
        MAGIC_SUB_PAGE_NAME("SUBPAGENAME"),
        MAGIC_SUB_PAGE_NAME_E("SUBPAGENAMEE"),
        MAGIC_BASE_PAGE_NAME("BASEPAGENAME"),
        MAGIC_BASE_PAGE_NAME_E("BASEPAGENAMEE"),
        MAGIC_NAMESPACE("NAMESPACE"),
        MAGIC_NAMESPACE_E("NAMESPACEE"),
        MAGIC_NAMESPACENUMBER("NAMESPACENUMBER"),
        MAGIC_FULL_PAGE_NAME("FULLPAGENAME"),
        MAGIC_FULL_PAGE_NAME_E("FULLPAGENAMEE"),
        MAGIC_FULL_URL("FULLURL"),
        MAGIC_FULL_URL_E("FULLURLE"),
        MAGIC_FILEPATH("FILEPATH"),
        MAGIC_TALK_SPACE("TALKSPACE"),
        MAGIC_TALK_SPACE_E("TALKSPACEE"),
        MAGIC_SUBJECT_SPACE("SUBJECTSPACE"),
        MAGIC_SUBJECT_SPACE_E("SUBJECTSPACEE"),
        MAGIC_ARTICLE_SPACE("ARTICLESPACE"),
        MAGIC_ARTICLE_SPACE_E("ARTICLESPACEE"),
        MAGIC_TALK_PAGE_NAME("TALKPAGENAME"),
        MAGIC_TALK_PAGE_NAME_E("TALKPAGENAMEE"),
        MAGIC_SUBJECT_PAGE_NAME("SUBJECTPAGENAME"),
        MAGIC_SUBJECT_PAGE_NAME_E("SUBJECTPAGENAMEE"),
        MAGIC_ARTICLE_PAGE_NAME("ARTICLEPAGENAME"),
        MAGIC_ARTICLE_PAGE_NAME_E("ARTICLEPAGENAMEE"),
        MAGIC_REVISION_ID("REVISIONID"),
        MAGIC_REVISION_DAY("REVISIONDAY"),
        MAGIC_REVISION_DAY2("REVISIONDAY2"),
        MAGIC_REVISION_MONTH("REVISIONMONTH"),
        MAGIC_REVISION_MONTH1("REVISIONMONTH1"),
        MAGIC_REVISION_YEAR("REVISIONYEAR"),
        MAGIC_REVISION_TIMESTAMP("REVISIONTIMESTAMP"),
        MAGIC_REVISION_USER("REVISIONUSER"),
        MAGIC_PAGEID("PAGEID"),
        MAGIC_PROTECTION_LEVEL("PROTECTIONLEVEL"),
        MAGIC_PROTECTIONEXPIRY("PROTECTIONEXPIRY"),
        MAGIC_CASCADINGSOURCES("CASCADINGSOURCES"),
        MAGIC_DISPLAY_TITLE("DISPLAYTITLE"),
        MAGIC_DEFAULT_SORT("DEFAULTSORT"),
        MAGIC_DEFAULT_SORT_KEY("DEFAULTSORTKEY"),
        MAGIC_DEFAULT_CATEGORY_SORT("DEFAULTCATEGORYSORT"),
        MAGIC_SITE_NAME("SITENAME"),
        MAGIC_SERVER("SERVER"),
        MAGIC_SCRIPT_PATH("SCRIPTPATH"),
        MAGIC_SERVER_NAME("SERVERNAME"),
        MAGIC_STYLE_PATH("STYLEPATH"),
        MAGIC_CONTENT_LANGUAGE("CONTENTLANGUAGE"),
        MAGIC_CONTENT_LANG("CONTENTLANG"),
        MAGIC_BANG("!");

        private final String text;

        private MagicWordE(String text) {
            this.text = text;
            MAGIC_WORDS.put(text.toLowerCase(), this);
        }

        public String toString() {
            return this.text;
        }

        public static MagicWordE fromString(String text) {
            if (text == null) {
                return null;
            }
            return MAGIC_WORDS.get(text.toLowerCase());
        }
    }
}

