/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.filter;

import info.bliki.wiki.filter.ITextConverter;
import info.bliki.wiki.filter.Util;
import info.bliki.wiki.filter.WPCell;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.tags.HTMLTag;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class WPRow {
    private List<WPCell> fCells;
    private String fParams;
    private int fType;
    private Map<String, String> fAttributes;

    public WPRow(List<WPCell> cells) {
        this.fCells = cells;
        this.fParams = null;
        this.fType = 1;
        this.fAttributes = null;
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.fAttributes);
    }

    public String getParams() {
        return this.fParams;
    }

    public void setParams(String params) {
        this.fParams = params;
        this.fAttributes = Util.getAttributes(params);
    }

    public boolean add(WPCell cell) {
        return this.fCells.add(cell);
    }

    public WPCell get(int index) {
        return this.fCells.get(index);
    }

    public int size() {
        return this.fCells.size();
    }

    public void renderHTML(ITextConverter converter, Appendable buf, IWikiModel wikiModel) throws IOException {
        if (this.fCells.size() > 0) {
            if (this.fType == 4) {
                if (this.fCells.size() == 1) {
                    this.fCells.get(0).renderHTML(converter, buf, wikiModel);
                }
            } else {
                buf.append("\n<tr");
                HTMLTag.appendEscapedAttributes(buf, this.fAttributes);
                buf.append(">");
                for (int i = 0; i < this.fCells.size(); ++i) {
                    WPCell cell = this.fCells.get(i);
                    cell.renderHTML(converter, buf, wikiModel);
                }
                buf.append("</tr>");
            }
        }
    }

    public void renderPlainText(ITextConverter converter, Appendable buf, IWikiModel wikiModel) throws IOException {
        if (this.fCells.size() > 0) {
            if (this.fType == 4) {
                if (this.fCells.size() == 1) {
                    buf.append("\n");
                    this.fCells.get(0).renderPlainText(converter, buf, wikiModel);
                }
            } else {
                buf.append("\n");
                for (int i = 0; i < this.fCells.size(); ++i) {
                    WPCell cell = this.fCells.get(i);
                    cell.renderPlainText(converter, buf, wikiModel);
                    buf.append(" ");
                }
            }
        }
    }

    public int getNumColumns() {
        return this.fCells.size();
    }

    public int getType() {
        return this.fType;
    }

    public void setType(int type) {
        this.fType = type;
    }
}

