/*
 * Decompiled with CFR 0.152.
 */
package cucumber.deps.com.thoughtworks.xstream.mapper;

import cucumber.deps.com.thoughtworks.xstream.converters.Converter;
import cucumber.deps.com.thoughtworks.xstream.converters.SingleValueConverter;
import cucumber.deps.com.thoughtworks.xstream.mapper.CannotResolveClassException;
import cucumber.deps.com.thoughtworks.xstream.mapper.Mapper;

public class DefaultMapper
implements Mapper {
    private static String XSTREAM_PACKAGE_ROOT;
    private final ClassLoader classLoader;

    public DefaultMapper(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public String serializedClass(Class type) {
        return type.getName();
    }

    public Class realClass(String elementName) {
        try {
            if (elementName.startsWith(XSTREAM_PACKAGE_ROOT)) {
                return DefaultMapper.class.getClassLoader().loadClass(elementName);
            }
            if (elementName.charAt(0) != '[') {
                return this.classLoader.loadClass(elementName);
            }
            if (elementName.endsWith(";")) {
                return Class.forName(elementName.toString(), false, this.classLoader);
            }
            return Class.forName(elementName.toString());
        }
        catch (ClassNotFoundException e) {
            throw new CannotResolveClassException(elementName);
        }
    }

    public Class defaultImplementationOf(Class type) {
        return type;
    }

    public String aliasForAttribute(String attribute) {
        return attribute;
    }

    public String attributeForAlias(String alias) {
        return alias;
    }

    public String aliasForSystemAttribute(String attribute) {
        return attribute;
    }

    public boolean isImmutableValueType(Class type) {
        return false;
    }

    public String getFieldNameForItemTypeAndName(Class definedIn, Class itemType, String itemFieldName) {
        return null;
    }

    public Class getItemTypeForItemFieldName(Class definedIn, String itemFieldName) {
        return null;
    }

    public Mapper.ImplicitCollectionMapping getImplicitCollectionDefForFieldName(Class itemType, String fieldName) {
        return null;
    }

    public boolean shouldSerializeMember(Class definedIn, String fieldName) {
        return true;
    }

    public String lookupName(Class type) {
        return this.serializedClass(type);
    }

    public Class lookupType(String elementName) {
        return this.realClass(elementName);
    }

    public String serializedMember(Class type, String memberName) {
        return memberName;
    }

    public String realMember(Class type, String serialized) {
        return serialized;
    }

    public SingleValueConverter getConverterFromAttribute(String name) {
        return null;
    }

    public SingleValueConverter getConverterFromItemType(String fieldName, Class type) {
        return null;
    }

    public SingleValueConverter getConverterFromItemType(Class type) {
        return null;
    }

    public SingleValueConverter getConverterFromItemType(String fieldName, Class type, Class definedIn) {
        return null;
    }

    public Converter getLocalConverter(Class definedIn, String fieldName) {
        return null;
    }

    public Mapper lookupMapperOfType(Class type) {
        return null;
    }

    public String aliasForAttribute(Class definedIn, String fieldName) {
        return fieldName;
    }

    public String attributeForAlias(Class definedIn, String alias) {
        return alias;
    }

    public SingleValueConverter getConverterFromAttribute(Class definedIn, String attribute) {
        return null;
    }

    public SingleValueConverter getConverterFromAttribute(Class definedIn, String attribute, Class type) {
        return null;
    }

    static {
        String packageName = DefaultMapper.class.getName();
        int idx = packageName.indexOf(".xstream.");
        XSTREAM_PACKAGE_ROOT = idx > 0 ? packageName.substring(0, idx + 9) : null;
    }
}

