/*
 * Decompiled with CFR 0.152.
 */
package gherkin.formatter;

import gherkin.formatter.AnsiFormats;
import gherkin.formatter.Argument;
import gherkin.formatter.Format;
import gherkin.formatter.Formats;
import gherkin.formatter.Formatter;
import gherkin.formatter.MonochromeFormats;
import gherkin.formatter.NiceAppendable;
import gherkin.formatter.Reporter;
import gherkin.formatter.StepPrinter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.BasicStatement;
import gherkin.formatter.model.CellResult;
import gherkin.formatter.model.Comment;
import gherkin.formatter.model.DescribedStatement;
import gherkin.formatter.model.DocString;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Row;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import gherkin.formatter.model.Tag;
import gherkin.formatter.model.TagStatement;
import gherkin.util.FixJava;
import gherkin.util.Mapper;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;

public class PrettyFormatter
implements Reporter,
Formatter {
    private final StepPrinter stepPrinter = new StepPrinter();
    private final NiceAppendable out;
    private boolean monochrome;
    private final boolean executing;
    private String uri;
    private Mapper tagNameMapper = new Mapper(){

        public String map(Object tag) {
            return ((Tag)tag).getName();
        }
    };
    private Formats formats;
    private Match match;
    private int[][] cellLengths;
    private int[] maxLengths;
    private int rowIndex;
    private List<? extends Row> rows;
    private Integer rowHeight = null;
    private boolean rowsAbove = false;
    private List<Step> steps = new ArrayList<Step>();
    private List<Integer> indentations = new ArrayList<Integer>();
    private DescribedStatement statement;
    private static final Pattern START = Pattern.compile("^", 8);
    private static final Pattern TRIPLE_QUOTES = Pattern.compile("\"\"\"", 8);
    private static final String ESCAPED_TRIPLE_QUOTES = "\\\\\"\\\\\"\\\\\"";

    public PrettyFormatter(Appendable out, boolean monochrome, boolean executing) {
        this.out = new NiceAppendable(out);
        this.executing = executing;
        this.setMonochrome(monochrome);
    }

    public void setMonochrome(boolean monochrome) {
        this.monochrome = monochrome;
        this.formats = monochrome ? new MonochromeFormats() : new AnsiFormats();
    }

    @Override
    public void uri(String uri) {
        this.uri = uri;
    }

    @Override
    public void feature(Feature feature) {
        this.printComments(feature.getComments(), "");
        this.printTags(feature.getTags(), "");
        this.out.println(feature.getKeyword() + ": " + feature.getName());
        this.printDescription(feature.getDescription(), "  ", false);
    }

    @Override
    public void background(Background background) {
        this.replay();
        this.statement = background;
    }

    @Override
    public void scenario(Scenario scenario) {
        this.replay();
        this.statement = scenario;
    }

    @Override
    public void scenarioOutline(ScenarioOutline scenarioOutline) {
        this.replay();
        this.statement = scenarioOutline;
    }

    private void replay() {
        this.printStatement();
        this.printSteps();
    }

    private void printSteps() {
        while (!this.steps.isEmpty()) {
            this.printStep("skipped", Collections.<Argument>emptyList(), null, true);
        }
    }

    private void printStatement() {
        if (this.statement == null) {
            return;
        }
        this.calculateLocationIndentations();
        this.out.println();
        this.printComments(this.statement.getComments(), "  ");
        if (this.statement instanceof TagStatement) {
            this.printTags(((TagStatement)this.statement).getTags(), "  ");
        }
        this.out.append("  ");
        this.out.append(this.statement.getKeyword());
        this.out.append(": ");
        this.out.append(this.statement.getName());
        String location = this.executing ? this.uri + ":" + this.statement.getLine() : null;
        this.out.println(this.indentedLocation(location, true));
        this.printDescription(this.statement.getDescription(), "    ", true);
        this.statement = null;
    }

    private String indentedLocation(String location, boolean proceed) {
        StringBuilder sb = new StringBuilder();
        int indentation = proceed ? this.indentations.remove(0) : this.indentations.get(0);
        if (location == null) {
            return "";
        }
        for (int i = 0; i < indentation; ++i) {
            sb.append(' ');
        }
        sb.append(' ');
        sb.append(this.getFormat("comment").text("# " + location));
        return sb.toString();
    }

    @Override
    public void examples(Examples examples) {
        this.replay();
        this.out.println();
        this.printComments(examples.getComments(), "    ");
        this.printTags(examples.getTags(), "    ");
        this.out.append("    ");
        this.out.append(examples.getKeyword());
        this.out.append(": ");
        this.out.append(examples.getName());
        this.out.println();
        this.printDescription(examples.getDescription(), "      ", true);
        this.table(examples.getRows());
    }

    @Override
    public void step(Step step) {
        this.steps.add(step);
    }

    @Override
    public void match(Match match) {
        this.match = match;
        this.printStatement();
        if (!this.monochrome) {
            this.printStep("executing", match.getArguments(), match.getLocation(), false);
        }
    }

    @Override
    public void embedding(String mimeType, InputStream data) {
    }

    @Override
    public void write(String text) {
        this.out.println(this.getFormat("output").text(text));
    }

    @Override
    public void result(Result result) {
        if (!this.monochrome) {
            this.out.append(this.formats.up(1));
        }
        this.printStep(result.getStatus(), this.match.getArguments(), this.match.getLocation(), true);
        if (result.getErrorMessage() != null) {
            this.printError(result);
        }
    }

    private void printStep(String status, List<Argument> arguments, String location, boolean proceed) {
        Step step = proceed ? this.steps.remove(0) : this.steps.get(0);
        Format textFormat = this.getFormat(status);
        Format argFormat = this.getArgFormat(status);
        this.printComments(step.getComments(), "    ");
        this.out.append("    ");
        this.out.append(textFormat.text(step.getKeyword()));
        this.stepPrinter.writeStep(this.out, textFormat, argFormat, step.getName(), arguments);
        this.out.append(this.indentedLocation(location, proceed));
        this.out.println();
        if (step.getRows() != null) {
            this.table(step.getRows());
        } else if (step.getDocString() != null) {
            this.docString(step.getDocString());
        }
    }

    private Format getFormat(String key) {
        return this.formats.get(key);
    }

    private Format getArgFormat(String key) {
        return this.formats.get(key + "_arg");
    }

    public void table(List<? extends Row> rows) {
        this.prepareTable(rows);
        if (!this.executing) {
            for (Row row : rows) {
                this.row(row.createResults("skipped"));
                this.nextRow();
            }
        }
    }

    private void prepareTable(List<? extends Row> rows) {
        this.rows = rows;
        int columnCount = rows.get(0).getCells().size();
        this.cellLengths = new int[rows.size()][columnCount];
        this.maxLengths = new int[columnCount];
        for (int rowIndex = 0; rowIndex < rows.size(); ++rowIndex) {
            Row row = rows.get(rowIndex);
            List<String> cells = row.getCells();
            for (int colIndex = 0; colIndex < columnCount; ++colIndex) {
                int length;
                String cell = cells.get(colIndex);
                this.cellLengths[rowIndex][colIndex] = length = this.escapeCell(cell).length();
                this.maxLengths[colIndex] = Math.max(this.maxLengths[colIndex], length);
            }
        }
        this.rowIndex = 0;
    }

    public void row(List<CellResult> cellResults) {
        Object cellText;
        Row row = this.rows.get(this.rowIndex);
        if (this.rowsAbove) {
            this.out.append(this.formats.up(this.rowHeight));
        } else {
            this.rowsAbove = true;
        }
        this.rowHeight = 1;
        for (Comment comment : row.getComments()) {
            this.out.append("      ");
            this.out.println(comment.getValue());
            Integer n = this.rowHeight;
            Integer n2 = this.rowHeight = Integer.valueOf(this.rowHeight + 1);
        }
        switch (row.getDiffType()) {
            case NONE: {
                this.out.append("      | ");
                break;
            }
            case DELETE: {
                this.out.append("    ").append(this.formats.get("skipped").text("-")).append(" | ");
                break;
            }
            case INSERT: {
                this.out.append("    ").append(this.formats.get("comment").text("+")).append(" | ");
            }
        }
        for (int colIndex = 0; colIndex < this.maxLengths.length; ++colIndex) {
            cellText = this.escapeCell(row.getCells().get(colIndex));
            String status = null;
            switch (row.getDiffType()) {
                case NONE: {
                    status = cellResults.get(colIndex).getStatus();
                    break;
                }
                case DELETE: {
                    status = "skipped";
                    break;
                }
                case INSERT: {
                    status = "comment";
                }
            }
            Format format = this.formats.get(status);
            this.out.append(format.text((String)cellText));
            int padding = this.maxLengths[colIndex] - this.cellLengths[this.rowIndex][colIndex];
            this.padSpace(padding);
            if (colIndex < this.maxLengths.length - 1) {
                this.out.append(" | ");
                continue;
            }
            this.out.append(" |");
        }
        this.out.println();
        Integer colIndex = this.rowHeight;
        this.rowHeight = this.rowHeight + 1;
        cellText = this.rowHeight;
        HashSet<Result> seenResults = new HashSet<Result>();
        for (CellResult cellResult : cellResults) {
            for (Result result : cellResult.getResults()) {
                if (result.getErrorMessage() == null || seenResults.contains(result)) continue;
                this.printError(result);
                this.rowHeight = this.rowHeight + result.getErrorMessage().split("\n").length;
                seenResults.add(result);
            }
        }
    }

    private void printError(Result result) {
        Format failed = this.formats.get("failed");
        this.out.println(PrettyFormatter.indent(failed.text(result.getErrorMessage()), "      "));
    }

    public void nextRow() {
        ++this.rowIndex;
        this.rowsAbove = false;
    }

    @Override
    public void syntaxError(String state, String event, List<String> legalEvents, String uri, int line) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void done() {
    }

    @Override
    public void close() {
        this.out.close();
    }

    private String escapeCell(String cell) {
        return cell.replaceAll("\\\\(?!\\|)", "\\\\\\\\").replaceAll("\\n", "\\\\n").replaceAll("\\|", "\\\\|");
    }

    public void docString(DocString docString) {
        this.out.println("      \"\"\"");
        this.out.append(PrettyFormatter.escapeTripleQuotes(PrettyFormatter.indent(docString.getValue(), "      ")));
        this.out.println("\n      \"\"\"");
    }

    @Override
    public void eof() {
        this.replay();
    }

    private void calculateLocationIndentations() {
        int[] lineWidths = new int[this.steps.size() + 1];
        int i = 0;
        ArrayList<BasicStatement> statements = new ArrayList<BasicStatement>();
        statements.add(this.statement);
        statements.addAll(this.steps);
        int maxLineWidth = 0;
        for (BasicStatement statement : statements) {
            int stepWidth = statement.getKeyword().length() + statement.getName().length();
            lineWidths[i++] = stepWidth;
            maxLineWidth = Math.max(maxLineWidth, stepWidth);
        }
        for (int lineWidth : lineWidths) {
            this.indentations.add(maxLineWidth - lineWidth);
        }
    }

    private void padSpace(int indent) {
        for (int i = 0; i < indent; ++i) {
            this.out.append(" ");
        }
    }

    private void printComments(List<Comment> comments, String indent) {
        for (Comment comment : comments) {
            this.out.append(indent);
            this.out.println(comment.getValue());
        }
    }

    private void printTags(List<Tag> tags, String indent) {
        if (tags.isEmpty()) {
            return;
        }
        this.out.append(indent);
        this.out.println(FixJava.join(FixJava.map(tags, this.tagNameMapper), " "));
    }

    private void printDescription(String description, String indentation, boolean newline) {
        if (!"".equals(description)) {
            this.out.println(PrettyFormatter.indent(description, indentation));
            if (newline) {
                this.out.println();
            }
        }
    }

    private static String indent(String s, String indentation) {
        return START.matcher(s).replaceAll(indentation);
    }

    private static String escapeTripleQuotes(String s) {
        return TRIPLE_QUOTES.matcher(s).replaceAll(ESCAPED_TRIPLE_QUOTES);
    }
}

