/*
 * Decompiled with CFR 0.152.
 */
package info.faljse.SDNotify.jna;

import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import info.faljse.SDNotify.io.NativeDomainSocket;
import java.nio.Buffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CLibrary {
    public static final int AF_UNIX = 1;
    public static final int SOCK_DGRAM = 2;
    private static final Logger log = Logger.getLogger(NativeDomainSocket.class.getName());
    public static final CLibrary clib = new CLibrary();

    public native int fcntl(int var1, int var2, int var3) throws LastErrorException;

    public native int ioctl(int var1, int var2, byte[] var3) throws LastErrorException;

    public native int ioctl(int var1, int var2, Pointer var3) throws LastErrorException;

    public native int open(String var1, int var2) throws LastErrorException;

    public native int close(int var1) throws LastErrorException;

    public native int write(int var1, Buffer var2, int var3) throws LastErrorException;

    public native int read(int var1, Buffer var2, int var3) throws LastErrorException;

    public native int socket(int var1, int var2, int var3) throws LastErrorException;

    public native int connect(int var1, SockAddr var2, int var3) throws LastErrorException;

    public native int bind(int var1, SockAddr var2, int var3) throws LastErrorException;

    public native int accept(int var1, SockAddr var2, Pointer var3) throws LastErrorException;

    public native int listen(int var1, int var2) throws LastErrorException;

    public native int getsockopt(int var1, int var2, int var3, byte[] var4, IntByReference var5);

    public native int setsockopt(int var1, int var2, int var3, byte[] var4, int var5);

    public native int recv(int var1, Buffer var2, int var3, int var4) throws LastErrorException;

    public native int recvfrom(int var1, Buffer var2, int var3, int var4, SockAddr var5, IntByReference var6);

    public native int send(int var1, Buffer var2, int var3, int var4) throws LastErrorException;

    public native int getpid() throws LastErrorException;

    static {
        try {
            Native.register((String)(Platform.isWindows() ? "msvcrt" : "c"));
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Native.register(\"c\") failed", e);
        }
    }

    public static class SockAddr
    extends Structure
    implements Structure.ByReference {
        public short family = 1;
        public byte[] addr = new byte[108];

        public SockAddr(String name) {
            System.arraycopy(name.getBytes(StandardCharsets.US_ASCII), 0, this.addr, 0, name.length());
        }

        protected List getFieldOrder() {
            return Arrays.asList("family", "addr");
        }
    }
}

