/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.dom4j;

import info.informatica.doc.dom4j.DOM4JCSSStyleSheet;
import info.informatica.doc.dom4j.LinkElement;
import info.informatica.doc.dom4j.StyleDefiner;
import info.informatica.doc.dom4j.StyleElement;
import info.informatica.doc.style.css.StyleDatabase;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.tree.DefaultDocument;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;

public class XHTMLDocument
extends DefaultDocument {
    private static final long serialVersionUID = 1L;
    private DOM4JCSSStyleSheet defStyleSheet = null;
    private DOM4JCSSStyleSheet mergedStyleSheet = null;
    private int styleCacheSerial = Integer.MIN_VALUE;
    private StyleDatabase styleDb = null;
    private URL baseURL = null;
    Set<LinkElement> linkedStyle = new HashSet<LinkElement>(3);
    Set<StyleElement> embeddedStyle = new HashSet<StyleElement>(3);

    public XHTMLDocument() {
    }

    public XHTMLDocument(String name) {
        super(name);
    }

    public XHTMLDocument(Element rootElement) {
        super(rootElement);
    }

    public XHTMLDocument(DocumentType docType) {
        super(docType);
    }

    public XHTMLDocument(Element rootElement, DocumentType docType) {
        super(rootElement, docType);
    }

    public XHTMLDocument(String name, Element rootElement, DocumentType docType) {
        super(name, rootElement, docType);
    }

    public DOM4JCSSStyleSheet getStyleSheet() {
        if (this.mergedStyleSheet == null) {
            this.mergeStyleSheets();
        }
        return this.mergedStyleSheet;
    }

    private void mergeStyleSheets() {
        try {
            this.mergedStyleSheet = (DOM4JCSSStyleSheet)this.defStyleSheet.clone();
        }
        catch (CloneNotSupportedException e) {
            return;
        }
        Iterator<LinkElement> links = this.linkedStyle.iterator();
        while (links.hasNext()) {
            try {
                links.next().mergeStyle();
            }
            catch (CSSException cSSException) {
                // empty catch block
            }
        }
        Iterator<StyleElement> embd = this.embeddedStyle.iterator();
        while (embd.hasNext()) {
            try {
                embd.next().mergeStyle();
            }
            catch (CSSException cSSException) {
                // empty catch block
            }
        }
    }

    public void addStyleSheet(InputSource cssSrc) throws DOMException, IOException, CSSException {
        this.getStyleSheet().parseCSSStyleSheet(cssSrc);
    }

    void onEmbeddedStyleAdd(StyleDefiner element) {
        if (element instanceof LinkElement) {
            this.linkedStyle.add((LinkElement)element);
        } else if (element instanceof StyleElement) {
            this.embeddedStyle.add((StyleElement)element);
        }
        this.onStyleModify();
    }

    void onEmbeddedStyleRemove(StyleDefiner element) {
        if (element instanceof LinkElement) {
            this.linkedStyle.remove(element);
        } else if (element instanceof StyleElement) {
            this.embeddedStyle.remove(element);
        }
        this.onStyleModify();
    }

    void onStyleModify() {
        if (this.mergedStyleSheet != null) {
            this.mergedStyleSheet = null;
            ++this.styleCacheSerial;
        }
    }

    int getStyleCacheSerial() {
        return this.styleCacheSerial;
    }

    public DOM4JCSSStyleSheet getDefaultStyleSheet() {
        return this.defStyleSheet;
    }

    public void setDefaultStyleSheet(DOM4JCSSStyleSheet styleSheet) {
        this.defStyleSheet = styleSheet;
        this.onStyleModify();
    }

    public StyleDatabase getStyleDatabase() {
        return this.styleDb;
    }

    public void setStyleDatabase(StyleDatabase styleDb) {
        this.styleDb = styleDb;
        this.onStyleModify();
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(URL baseURL) {
        this.baseURL = baseURL;
    }

    public URL getURL(String uri) throws MalformedURLException {
        if (uri.length() == 0) {
            throw new MalformedURLException("Empty URI");
        }
        URL url = uri.indexOf("//") < 0 ? new URL(this.getBaseURL(), uri) : new URL(uri);
        return url;
    }

    public URLConnection openConnection(String uri) throws IOException {
        return this.getURL(uri).openConnection();
    }

    public InputStream openStream(String uri) throws IOException {
        return this.getURL(uri).openStream();
    }
}

