/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.dom4j;

import info.informatica.doc.dom4j.BaseHrefAttribute;
import info.informatica.doc.dom4j.BaseURLElement;
import info.informatica.doc.dom4j.CSSStylableElement;
import info.informatica.doc.dom4j.CachedCSSStylableElement;
import info.informatica.doc.dom4j.CachedTableCellElement;
import info.informatica.doc.dom4j.CachedTableElement;
import info.informatica.doc.dom4j.CachedTableRowElement;
import info.informatica.doc.dom4j.CenterElement;
import info.informatica.doc.dom4j.DOM4JCSSStyleSheet;
import info.informatica.doc.dom4j.DocumentStyleEventAttribute;
import info.informatica.doc.dom4j.FontElement;
import info.informatica.doc.dom4j.HeadElement;
import info.informatica.doc.dom4j.LinkElement;
import info.informatica.doc.dom4j.StrikeElement;
import info.informatica.doc.dom4j.StyleAttribute;
import info.informatica.doc.dom4j.StyleElement;
import info.informatica.doc.dom4j.TableCellElement;
import info.informatica.doc.dom4j.TableElement;
import info.informatica.doc.dom4j.TableRowElement;
import info.informatica.doc.dom4j.UnderlineElement;
import info.informatica.doc.dom4j.XHTMLDocument;
import info.informatica.doc.style.css.CSSStyleSheetFactory;
import info.informatica.doc.style.css.StyleDatabase;
import info.informatica.doc.style.css.dom.DOMMediaList;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.tree.DefaultElement;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.MediaList;

public class XHTMLDocumentFactory
extends DocumentFactory {
    private static final long serialVersionUID = 1L;
    private DOM4JCSSStyleSheet defStyleSheet = null;
    private DOM4JCSSStyleSheetFactory cssFactory = new DOM4JCSSStyleSheetFactory();
    private boolean styleCacheOn = false;
    private StyleDatabase styleDb = null;
    protected static transient XHTMLDocumentFactory singleton = new XHTMLDocumentFactory();

    public static DocumentFactory getInstance() {
        return singleton;
    }

    public DOM4JCSSStyleSheet getDefaultStyleSheet() {
        if (this.defStyleSheet == null) {
            try {
                this.defStyleSheet = (DOM4JCSSStyleSheet)this.getCSSStyleSheetFactory().loadXHTMLDefaultSheet();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to load default style sheet.", e);
            }
        }
        return this.defStyleSheet;
    }

    public DOM4JCSSStyleSheetFactory getCSSStyleSheetFactory() {
        return this.cssFactory;
    }

    public void setDefaultStyleSheet(DOM4JCSSStyleSheet styleSheet) {
        this.defStyleSheet = styleSheet;
    }

    public boolean isStyleCacheOn() {
        return this.styleCacheOn;
    }

    public void setStyleCache(boolean onOff) {
        this.styleCacheOn = onOff;
    }

    public Element createElement(QName qname) {
        String name = qname.getName();
        if ("base".equals(name)) {
            return new BaseURLElement(qname);
        }
        if ("style".equals(name)) {
            return new StyleElement(qname);
        }
        if ("link".equals(name)) {
            return new LinkElement(qname);
        }
        if ("head".equals(name)) {
            return new HeadElement(qname);
        }
        if ("title".equals(name) || "meta".equals(name)) {
            return new DefaultElement(qname);
        }
        if ("font".equals(name) || "basefont".equals(name)) {
            return new FontElement(qname);
        }
        if ("center".equals(name)) {
            return new CenterElement(qname);
        }
        if ("u".equals(name)) {
            return new UnderlineElement(qname);
        }
        if ("s".equals(name) || "strike".equals(name)) {
            return new StrikeElement(qname);
        }
        if (this.styleCacheOn) {
            if ("td".equals(name) || "th".equals(name)) {
                return new CachedTableCellElement(qname);
            }
            if ("tr".equals(name)) {
                return new CachedTableRowElement(qname);
            }
            if ("table".equals(name)) {
                return new CachedTableElement(qname);
            }
            return new CachedCSSStylableElement(qname);
        }
        if ("td".equals(name) || "th".equals(name)) {
            return new TableCellElement(qname);
        }
        if ("tr".equals(name)) {
            return new TableRowElement(qname);
        }
        if ("table".equals(name)) {
            return new TableElement(qname);
        }
        return new CSSStylableElement(qname);
    }

    public Document createDocument() {
        XHTMLDocument mydoc = new XHTMLDocument();
        mydoc.setDocumentFactory(this);
        mydoc.setDefaultStyleSheet(this.getDefaultStyleSheet());
        if (this.styleDb != null) {
            mydoc.setStyleDatabase(this.styleDb);
        }
        return mydoc;
    }

    public Attribute createAttribute(Element owner, QName qname, String value) {
        if (owner instanceof LinkElement) {
            return new DocumentStyleEventAttribute(qname, value);
        }
        if (owner instanceof BaseURLElement && qname.getName().equals("href")) {
            return new BaseHrefAttribute(qname, value);
        }
        if (owner instanceof CachedCSSStylableElement && qname.getName().equals("style")) {
            return new StyleAttribute(qname, value);
        }
        return super.createAttribute(owner, qname, value);
    }

    public StyleDatabase getStyleDatabase() {
        return this.styleDb;
    }

    public void setStyleDatabase(StyleDatabase styleDb) {
        this.styleDb = styleDb;
    }

    public class DOM4JCSSStyleSheetFactory
    extends CSSStyleSheetFactory {
        DOM4JCSSStyleSheetFactory() {
        }

        public CSSStyleSheet createStyleSheet(String namespaceUri, MediaList mediaList) {
            return this.createStyleSheet(null, namespaceUri, mediaList);
        }

        public DOM4JCSSStyleSheet createStyleSheet(Element ownerElement, String namespaceUri, MediaList mediaList) {
            if (mediaList == null) {
                throw new NullPointerException("Null media list");
            }
            DOM4JCSSStyleSheet css = new DOM4JCSSStyleSheet((CSSStyleSheetFactory)this, ownerElement, (DOMMediaList)mediaList);
            if (ownerElement != null) {
                String title = ownerElement.attributeValue("title");
                css.setTitle(title);
            }
            css.setNamespaceURI(namespaceUri);
            return css;
        }
    }
}

