/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.pdf.itext;

import com.lowagie.text.BadElementException;
import info.informatica.doc.agent.DownloadListener;
import info.informatica.doc.agent.UserAgent;
import info.informatica.doc.dom4j.CSSStylableElement;
import info.informatica.doc.dom4j.XHTMLDocument;
import info.informatica.doc.style.css.j2d.ImgReplacedBox;
import info.informatica.doc.style.css.visual.CSSReplacementException;
import info.informatica.doc.style.css.visual.box.AbstractReplacedBox;
import java.awt.Image;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFImgReplacedBox
extends AbstractReplacedBox
implements DownloadListener<com.lowagie.text.Image> {
    private com.lowagie.text.Image image = null;

    public PDFImgReplacedBox(CSSStylableElement elem) {
        super(elem);
    }

    @Override
    public void init(UserAgent agent) throws CSSReplacementException {
        String imgUri = this.getReplacedElement().attributeValue("src");
        if (imgUri == null || imgUri.length() == 0) {
            throw new CSSReplacementException("img element has no src attribute.");
        }
        try {
            agent.addDownloadListener(((XHTMLDocument)this.getReplacedElement().getDocument()).getURL(imgUri), this);
        }
        catch (IOException e) {
            this.image = this.getBrokenImage();
            throw new CSSReplacementException(e);
        }
    }

    @Override
    public void doContentDownloaded(com.lowagie.text.Image img) {
        this.image = img;
    }

    @Override
    public void doFailedDownload() {
        this.image = this.getBrokenImage();
    }

    private com.lowagie.text.Image getBrokenImage() {
        try {
            return com.lowagie.text.Image.getInstance((Image)ImgReplacedBox.getBrokenImage(), null);
        }
        catch (BadElementException badElementException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public com.lowagie.text.Image getNativeContent() {
        return this.image;
    }

    @Override
    public float getIntrinsicHeight() {
        return this.image.plainHeight();
    }

    @Override
    public float getIntrinsicWidth() {
        return this.image.plainWidth();
    }
}

