/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.dom;

import info.informatica.doc.style.css.dom.DOMCSSFontFaceRule;
import info.informatica.doc.style.css.dom.DOMCSSImportRule;
import info.informatica.doc.style.css.dom.DOMCSSMediaRule;
import info.informatica.doc.style.css.dom.DOMCSSPageRule;
import info.informatica.doc.style.css.dom.DOMCSSStyleRule;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleSheet;

public abstract class BaseCSSRule
implements CSSRule {
    private CSSStyleSheet parentSheet = null;
    private CSSRule parentRule = null;
    private final short ruleType;
    protected int insertionIndex = 0;

    public BaseCSSRule(CSSStyleSheet parentSheet, short type) {
        this.parentSheet = parentSheet;
        this.ruleType = type;
    }

    public short getType() {
        return this.ruleType;
    }

    public abstract String getCssText();

    public abstract void setCssText(String var1) throws DOMException;

    public CSSStyleSheet getParentStyleSheet() {
        return this.parentSheet;
    }

    public CSSRule getParentRule() {
        return this.parentRule;
    }

    public void setParentRule(CSSRule parent) {
        this.parentRule = parent;
    }

    public static CSSRule createCSSRule(CSSStyleSheet parentSheet, int type) {
        BaseCSSRule rule = null;
        switch (type) {
            case 1: {
                rule = new DOMCSSStyleRule(parentSheet);
            }
            case 5: {
                rule = new DOMCSSFontFaceRule(parentSheet);
            }
            case 3: {
                rule = new DOMCSSImportRule(parentSheet);
            }
            case 4: {
                rule = new DOMCSSMediaRule(parentSheet);
            }
            case 6: {
                rule = new DOMCSSPageRule(parentSheet);
            }
        }
        return rule;
    }

    public void setInsertionIndex(int index) {
        this.insertionIndex = index;
    }
}

