/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.dom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.w3c.css.sac.SACMediaList;
import org.w3c.dom.DOMException;
import org.w3c.dom.stylesheets.MediaList;

public class DOMMediaList
implements MediaList {
    private List<String> mediaList = new ArrayList<String>(5);

    public String getMediaText() {
        StringBuilder sb = new StringBuilder(this.mediaList.size() * 8 + 2);
        Iterator<String> it = this.mediaList.iterator();
        if (it.hasNext()) {
            sb.append(it.next());
        }
        while (it.hasNext()) {
            sb.append(',').append(it.next());
        }
        return sb.toString();
    }

    public void setMediaText(String mediaText) throws DOMException {
        StringTokenizer st = new StringTokenizer(mediaText);
        while (st.hasMoreElements()) {
            this.appendMedium(st.nextToken());
        }
    }

    public int getLength() {
        return this.mediaList.size();
    }

    public String item(int index) {
        return this.mediaList.get(index);
    }

    public void deleteMedium(String oldMedium) throws DOMException {
        this.mediaList.remove(oldMedium);
    }

    public void appendMedium(String newMedium) throws DOMException {
        this.mediaList.add(newMedium);
    }

    boolean match(SACMediaList sacMedia) {
        int sz = sacMedia.getLength();
        int i = 0;
        while (i < sz) {
            String iitem = sacMedia.item(i).toLowerCase();
            if (this.mediaList.contains(iitem) || "all".equals(iitem)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void appendSACMediaList(SACMediaList sacMedia) {
        int sz = sacMedia.getLength();
        int i = 0;
        while (i < sz) {
            this.appendMedium(sacMedia.item(i));
            ++i;
        }
    }

    public String toString() {
        return this.getMediaText();
    }
}

