/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.visual.box;

import info.informatica.doc.style.css.CSS2ComputedProperties;
import info.informatica.doc.style.css.property.CSSNumberValue;
import info.informatica.doc.style.css.property.CSSStringValue;
import info.informatica.doc.style.css.visual.CSSContainerBox;
import info.informatica.doc.style.css.visual.box.AbstractCSSBox;
import org.w3c.dom.css.CSSPrimitiveValue;

public abstract class AbstractBlockBox
extends AbstractCSSBox {
    private final float UNSET_FLOAT_VALUE = Float.MIN_VALUE;
    private float boxWidth = Float.MIN_VALUE;
    private float boxHeight = Float.MIN_VALUE;

    public AbstractBlockBox(CSS2ComputedProperties style) {
        super(style);
    }

    public float getWidth() {
        if (this.boxWidth == Float.MIN_VALUE) {
            CSSPrimitiveValue cssValue = this.getCSSValue("width");
            short primiType = cssValue.getPrimitiveType();
            if (primiType == this.getStyleDatabase().getNaturalUnit()) {
                this.boxWidth = cssValue.getFloatValue(this.getStyleDatabase().getNaturalUnit());
            } else if (primiType == 2) {
                this.boxWidth = this.getContainerWidth() * cssValue.getFloatValue((short)2) / 100.0f;
            } else if (cssValue instanceof CSSNumberValue) {
                this.boxWidth = cssValue.getFloatValue(primiType);
            } else {
                this.boxWidth = this.getContainerWidth() - this.getMarginLeft() - this.getBorderLeftWidth() - this.getMarginRight() - this.getBorderRightWidth();
                if (this.overflowsWithScroll()) {
                    this.boxWidth -= this.getStyleDatabase().getScrollbarWidth();
                }
                this.boxWidth -= this.getPaddingLeft();
                this.boxWidth -= this.getPaddingRight();
            }
        }
        return this.boxWidth;
    }

    public float getHeight() {
        if (this.boxHeight == Float.MIN_VALUE) {
            CSSPrimitiveValue cssValue = this.getCSSValue("height");
            short primiType = cssValue.getPrimitiveType();
            if (primiType == this.getStyleDatabase().getNaturalUnit()) {
                this.boxHeight = cssValue.getFloatValue(this.getStyleDatabase().getNaturalUnit());
            } else if (primiType == 2) {
                if (this.isContainerHeightAuto()) {
                    this.boxHeight = this.computeAutoHeight(this.getWidth());
                } else {
                    CSSContainerBox container = this.getContainingBlock();
                    float containerHeight = container != null ? container.getHeight() : this.getStyleDatabase().getDocumentHeight();
                    this.boxHeight = containerHeight * cssValue.getFloatValue((short)2) / 100.0f;
                }
            } else {
                this.boxHeight = cssValue instanceof CSSNumberValue ? cssValue.getFloatValue(primiType) : this.computeAutoHeight(this.getWidth());
            }
        }
        return this.boxHeight;
    }

    protected abstract float computeAutoHeight(float var1);

    public float getMarginTop() {
        return this.computeMarginSubproperty("margin-top", false);
    }

    public float getMarginBottom() {
        return this.computeMarginSubproperty("margin-bottom", false);
    }

    public float getMarginRight() {
        return this.computeMarginSubproperty("margin-right", false);
    }

    public float getMarginLeft() {
        return this.computeMarginSubproperty("margin-left", false);
    }

    protected float computeMarginSubproperty(String marginProperty, boolean auto) {
        CSSPrimitiveValue cssval = this.getCSSValue(marginProperty);
        float margin = cssval.getPrimitiveType() == 2 ? this.getContainerWidth() * cssval.getFloatValue((short)2) / 100.0f : (cssval.getPrimitiveType() == 3 ? (float)this.getComputedStyle().getFontSize() * cssval.getFloatValue((short)3) : (cssval instanceof CSSNumberValue ? cssval.getFloatValue(this.getStyleDatabase().getNaturalUnit()) : (cssval instanceof CSSStringValue ? ((cssval = this.getCSSValue("width")) instanceof CSSStringValue || auto ? 0.0f : (marginProperty.equals("margin-right") ? this.automaticRightMargin() : (marginProperty.equals("margin-left") ? this.automaticLeftMargin() : 0.0f))) : 0.0f)));
        return margin;
    }

    protected float automaticRightMargin() {
        float margin;
        CSSPrimitiveValue cssval = this.getCSSValue("margin-left");
        if (cssval instanceof CSSStringValue) {
            margin = (this.getContainerWidth() - this.getBorderLeftWidth() - this.getBorderRightWidth() - this.getWidth()) / 2.0f;
        } else {
            CSSPrimitiveValue cssWidth = this.getCSSValue("width");
            if (cssWidth instanceof CSSStringValue) {
                margin = this.getMarginLeft();
            } else {
                margin = this.getContainerWidth() - this.getMarginLeft() - this.getBorderLeftWidth() - this.getBorderRightWidth() - this.getWidth();
                if (this.overflowsWithScroll()) {
                    margin -= this.getStyleDatabase().getScrollbarWidth();
                }
            }
        }
        return margin;
    }

    protected float automaticLeftMargin() {
        float margin;
        CSSPrimitiveValue cssval = this.getCSSValue("margin-right");
        if (cssval instanceof CSSStringValue) {
            margin = (this.getContainerWidth() - this.getBorderLeftWidth() - this.getBorderRightWidth()) / 2.0f;
        } else {
            CSSPrimitiveValue cssWidth = this.getCSSValue("width");
            if (cssWidth instanceof CSSStringValue) {
                margin = this.getMarginRight();
            } else {
                margin = this.getContainerWidth() - this.getMarginRight() - this.getBorderLeftWidth() - this.getBorderRightWidth() - this.getWidth();
                if (this.overflowsWithScroll()) {
                    margin -= this.getStyleDatabase().getScrollbarWidth();
                }
            }
        }
        return margin;
    }

    protected float computeScrollbarWidth() {
        if (this.overflowsWithScroll()) {
            return this.getStyleDatabase().getScrollbarWidth();
        }
        return 0.0f;
    }
}

