/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.visual.box;

import info.informatica.doc.dom4j.CSSStylableElement;
import info.informatica.doc.style.css.CSS2ComputedProperties;
import info.informatica.doc.style.css.property.CSSNumberValue;
import info.informatica.doc.style.css.visual.ReplacedElementBox;
import info.informatica.doc.style.css.visual.box.AbstractCSSBox;
import org.w3c.dom.css.CSSPrimitiveValue;

public abstract class AbstractReplacedBox
extends AbstractCSSBox
implements ReplacedElementBox {
    private CSSStylableElement replacedElement;

    public AbstractReplacedBox(CSSStylableElement replaced) {
        super((CSS2ComputedProperties)((Object)replaced.getComputedStyle()));
        this.replacedElement = replaced;
    }

    protected CSSStylableElement getReplacedElement() {
        return this.replacedElement;
    }

    public float getWidth() {
        float boxWidth;
        CSSPrimitiveValue cssValue = this.getCSSValue("width");
        short primiType = cssValue.getPrimitiveType();
        if (primiType == this.getStyleDatabase().getNaturalUnit()) {
            boxWidth = cssValue.getFloatValue(this.getStyleDatabase().getNaturalUnit());
        } else if (primiType == 2) {
            boxWidth = this.getContainerWidth() * cssValue.getFloatValue((short)2) / 100.0f;
        } else if (cssValue instanceof CSSNumberValue) {
            boxWidth = cssValue.getFloatValue(primiType);
        } else {
            String sWidth = this.replacedElement.attributeValue("width");
            if (sWidth != null && sWidth.length() > 0) {
                try {
                    return Integer.parseInt(sWidth);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            boxWidth = this.getIntrinsicWidth();
        }
        return boxWidth;
    }

    public float getHeight() {
        float boxHeight;
        CSSPrimitiveValue cssValue = this.getCSSValue("height");
        short primiType = cssValue.getPrimitiveType();
        if (primiType == this.getStyleDatabase().getNaturalUnit()) {
            boxHeight = cssValue.getFloatValue(this.getStyleDatabase().getNaturalUnit());
        } else if (primiType == 2) {
            boxHeight = this.getContainerWidth() * cssValue.getFloatValue((short)2) / 100.0f;
        } else if (cssValue instanceof CSSNumberValue) {
            boxHeight = cssValue.getFloatValue(primiType);
        } else {
            String sHeight = this.replacedElement.attributeValue("height");
            if (sHeight != null && sHeight.length() > 0) {
                try {
                    return Integer.parseInt(sHeight);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            boxHeight = this.getIntrinsicHeight();
        }
        return boxHeight;
    }
}

