/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.visual.box;

import info.informatica.doc.style.css.CSS2ComputedProperties;
import info.informatica.doc.style.css.property.CSSNumberValue;
import info.informatica.doc.style.css.visual.CSSContainerBox;
import info.informatica.doc.style.css.visual.NonStaticallyPositioned;
import info.informatica.doc.style.css.visual.box.AbstractCSSBox;
import org.w3c.dom.css.CSSPrimitiveValue;

public abstract class FloatingBox
extends AbstractCSSBox
implements NonStaticallyPositioned {
    private float boxWidth;

    FloatingBox(CSS2ComputedProperties style) {
        super(style);
        this.computeDimension(0.0f, 0.0f);
    }

    public void computeDimension() {
        this.computeDimension(0.0f, 0.0f);
    }

    public void computeDimension(float preferredMinimumWidth, float preferredWidth) {
        CSSPrimitiveValue cssValue = this.getCSSValue("width");
        short primiType = cssValue.getPrimitiveType();
        if (primiType == this.getStyleDatabase().getNaturalUnit()) {
            this.boxWidth = cssValue.getFloatValue(this.getStyleDatabase().getNaturalUnit());
        } else if (primiType == 2) {
            this.boxWidth = this.getContainerWidth() * cssValue.getFloatValue((short)2) / 100.0f;
        } else if (cssValue instanceof CSSNumberValue) {
            this.boxWidth = cssValue.getFloatValue(primiType);
        } else {
            this.boxWidth = this.getContainerWidth() - this.getMarginLeft() - this.getBorderLeftWidth() - this.getMarginRight() - this.getBorderRightWidth();
            if (this.overflowsWithScroll()) {
                this.boxWidth -= this.getStyleDatabase().getScrollbarWidth();
            }
            this.boxWidth -= this.getPaddingLeft();
            this.boxWidth -= this.getPaddingRight();
            if (preferredWidth != 0.0f) {
                this.boxWidth = this.shrinkToFit(preferredMinimumWidth, this.boxWidth, preferredWidth);
            }
        }
    }

    public float getWidth() {
        return this.boxWidth;
    }

    public float getHeight() {
        float boxHeight;
        CSSPrimitiveValue cssValue = this.getCSSValue("height");
        short primiType = cssValue.getPrimitiveType();
        if (primiType == this.getStyleDatabase().getNaturalUnit()) {
            boxHeight = cssValue.getFloatValue(this.getStyleDatabase().getNaturalUnit());
        } else if (primiType == 2) {
            if (this.isContainerHeightAuto()) {
                boxHeight = this.computeAutoHeight(this.getWidth());
            } else {
                CSSContainerBox container = this.getContainingBlock();
                float containerHeight = container != null ? container.getHeight() : this.getStyleDatabase().getDocumentHeight();
                boxHeight = containerHeight * cssValue.getFloatValue((short)2) / 100.0f;
            }
        } else {
            boxHeight = cssValue instanceof CSSNumberValue ? cssValue.getFloatValue(primiType) : this.computeAutoHeight(this.getWidth());
        }
        return boxHeight;
    }

    protected abstract float computeAutoHeight(float var1);
}

