/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.visual.box;

import info.informatica.doc.style.css.CSS2ComputedProperties;
import info.informatica.doc.style.css.dom.ComputedCSSStyle;
import info.informatica.doc.style.css.visual.CSSInlineBox;
import info.informatica.doc.style.css.visual.box.AbstractInlineBox;

public class InlineBox
extends AbstractInlineBox
implements CSSInlineBox {
    public InlineBox(CSS2ComputedProperties style) {
        super(style);
    }

    public String getText() {
        return ((ComputedCSSStyle)this.getComputedStyle()).getText();
    }

    protected float getWidth() {
        return this.getContentWidth();
    }

    public float getContentWidth() {
        return this.textLengthToNaturalUnit(this.getText().length());
    }

    public float getMinimumWidth() {
        String text = this.getText();
        int tlen = text.length();
        int maxsz = 0;
        int j = 0;
        int i = 0;
        while (i < tlen) {
            if (!Character.isLetterOrDigit(text.charAt(i))) {
                int k = i - j;
                if (k > maxsz) {
                    maxsz = k;
                }
                j = i;
                ++j;
                while (j < tlen && !Character.isLetterOrDigit(text.charAt(j))) {
                    ++j;
                }
                i = j;
                continue;
            }
            ++i;
        }
        if (j > 0) {
            if (tlen - j > maxsz) {
                maxsz = tlen - j;
            }
        } else {
            maxsz = tlen;
        }
        return this.textLengthToNaturalUnit(maxsz);
    }

    protected float getHeight() {
        return this.getContentHeight();
    }

    public float getContentHeight() {
        return this.getStyleDatabase().floatValueConversion(this.getFontSize(), (short)9);
    }

    public float computeHeight(float width) {
        int chWidth = (int)Math.floor(this.getStyleDatabase().floatValueConversion(width, this.getStyleDatabase().getNaturalUnit(), (short)9) / (float)this.getStyleDatabase().getExSizeInPt(this.getFontFamily(), this.getFontSize()));
        if (chWidth == 0) {
            return Float.NaN;
        }
        String text = this.getText();
        int lineCount = 1;
        int tLen = text.length();
        if (chWidth <= tLen) {
            int from;
            int lbound = 0;
            int i = 0;
            while ((from = i + chWidth) < tLen) {
                i = InlineBox.lastNonLetterOrDigitIndex(text, from, lbound);
                if (i == lbound) {
                    i = InlineBox.nonLetterOrDigitIndex(text, from, chWidth);
                }
                lbound = ++i;
                ++lineCount;
                if (i < tLen) continue;
            }
        }
        return this.getStyleDatabase().floatValueConversion(this.getFontSize() * lineCount, (short)9);
    }

    static int nonLetterOrDigitIndex(CharSequence seq, int fromIndex, int upperBound) {
        int i = fromIndex;
        while (i < upperBound && Character.isLetterOrDigit(seq.charAt(i))) {
            ++i;
        }
        return i;
    }

    static int lastNonLetterOrDigitIndex(CharSequence seq, int fromIndex, int lowerBound) {
        int i = fromIndex;
        while (i > lowerBound && Character.isLetterOrDigit(seq.charAt(i))) {
            --i;
        }
        return i;
    }

    public float textLengthToNaturalUnit(int length) {
        return super.textLengthToNaturalUnit(length);
    }
}

