/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.visual.box;

import info.informatica.doc.style.css.visual.CSSBox;
import info.informatica.doc.style.css.visual.CSSInlineBox;
import info.informatica.doc.style.css.visual.box.AbstractCSSBox;
import info.informatica.doc.style.css.visual.box.InlineBox;
import info.informatica.doc.style.css.visual.container.CSSInlineBoxContainer;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InlineContainer
implements CSSInlineBoxContainer {
    private List<CSSBox> inline;
    private boolean overflowsWidth = false;

    public InlineContainer() {
        this.inline = new ArrayList<CSSBox>();
    }

    public InlineContainer(int size) {
        this.inline = new ArrayList<CSSBox>(size);
    }

    public List<CSSBox> getInlineBoxList() {
        return this.inline;
    }

    public CSSInlineBox[] getInlineBoxes() {
        return this.inline.toArray(new CSSInlineBox[0]);
    }

    protected void setOverflowsWidth() {
        this.overflowsWidth = true;
    }

    @Override
    public boolean overflowsWidth() {
        return this.overflowsWidth;
    }

    @Override
    public float getContentWidth() {
        float width = 0.0f;
        int i = 0;
        while (i < this.inline.size()) {
            if (this.inline.get(i) instanceof InlineBox) {
                width += ((InlineBox)this.inline.get(i)).getContentWidth();
            }
            ++i;
        }
        return width;
    }

    @Override
    public float getMinimumWidth() {
        float width = 0.0f;
        int i = 0;
        while (i < this.inline.size()) {
            if (this.inline.get(i) instanceof InlineBox) {
                width = Math.max(((InlineBox)this.inline.get(i)).getMinimumWidth(), width);
            }
            ++i;
        }
        return width;
    }

    @Override
    public float computeHeight(float width) {
        float height = 0.0f;
        int chStart = 0;
        AbstractCSSBox box = null;
        int i = 0;
        while (i < this.inline.size()) {
            if (this.inline.get(i) instanceof InlineBox) {
                box = (InlineBox)this.inline.get(i);
                int chWidth = (int)Math.floor(box.getStyleDatabase().floatValueConversion(width, box.getStyleDatabase().getNaturalUnit(), (short)9) / (float)box.getStyleDatabase().getExSizeInPt(box.getFontFamily(), box.getFontSize()));
                if (chWidth == 0) {
                    return Float.NaN;
                }
                int availW = chWidth - chStart;
                String text = ((InlineBox)box).getText();
                int lineCount = 0;
                int j = 0;
                int tLen = text.length();
                if (availW <= tLen) {
                    int from;
                    int lbound = 0;
                    while ((from = j + availW) < tLen) {
                        j = InlineBox.lastNonLetterOrDigitIndex(text, from, lbound);
                        if (j == lbound) {
                            this.setOverflowsWidth();
                            j = InlineBox.nonLetterOrDigitIndex(text, from, availW);
                        }
                        ++i;
                        lbound = j;
                        availW = chWidth;
                        ++lineCount;
                        if (j < tLen) continue;
                    }
                }
                chStart = availW - j;
                height += box.getStyleDatabase().floatValueConversion(box.getFontSize() * lineCount, (short)9);
            }
            ++i;
        }
        if (box != null) {
            height += box.getStyleDatabase().floatValueConversion(box.getFontSize(), (short)9);
        }
        return height;
    }
}

