/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.xml.dtd;

import info.informatica.doc.xml.dtd.DocumentTypeDeclaration;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class DefaultEntityResolver
implements EntityResolver2 {
    protected Map<String, String> dtdNameToFilename = new HashMap<String, String>(7);
    protected Map<String, String> dtdNameToURL = new HashMap<String, String>(7);
    private ClassLoader loader = null;

    public DefaultEntityResolver() {
        this.dtdNameToFilename.put("-//W3C//DTD XHTML 1.0 Strict//EN", "w3c/xhtml1-strict.dtd");
        this.dtdNameToFilename.put("-//W3C//DTD XHTML 1.0 Transitional//EN", "w3c/xhtml1-transitional.dtd");
        this.dtdNameToFilename.put("-//W3C//DTD XHTML 1.1//EN", "w3c/xhtml11.dtd");
        this.dtdNameToFilename.put("-//W3C//ENTITIES Latin 1 for XHTML//EN", "w3c/xhtml-lat1.ent");
        this.dtdNameToFilename.put("-//W3C//ENTITIES Symbols for XHTML//EN", "w3c/xhtml-symbol.ent");
        this.dtdNameToFilename.put("-//W3C//ENTITIES Special for XHTML//EN", "w3c/xhtml-special.ent");
        this.dtdNameToFilename.put("-//Genus Consulting//DTD XHTML1.0 plus Carte1.0//EN", "/info/informatica/report/dtd/xhtml1-carte1.dtd");
        this.dtdNameToURL.put("-//W3C//DTD XHTML 1.0 Strict//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd");
        this.dtdNameToURL.put("-//W3C//DTD XHTML 1.0 Transitional//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd");
        this.dtdNameToURL.put("-//W3C//DTD XHTML 1.1//EN", "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd");
        this.dtdNameToURL.put("-//W3C//ENTITIES Latin 1 for XHTML//EN", "http://www.w3.org/TR/xhtml11/DTD/xhtml-lat1.ent");
        this.dtdNameToURL.put("-//W3C//ENTITIES Symbols for XHTML//EN", "http://www.w3.org/TR/xhtml11/DTD/xhtml-symbol.ent");
        this.dtdNameToURL.put("-//W3C//ENTITIES Special for XHTML//EN", "http://www.w3.org/TR/xhtml11/DTD/xhtml-special.ent");
    }

    public void setClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
        return null;
    }

    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        Reader re;
        String fname = this.dtdNameToFilename.get(publicId);
        InputSource isrc = null;
        if (fname != null && (re = this.loadDTDfromClasspath(fname)) != null) {
            isrc = new InputSource(re);
            isrc.setPublicId(publicId);
            if (systemId != null) {
                isrc.setSystemId(systemId);
            }
        }
        return isrc;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        return this.resolveEntity(null, publicId, null, systemId);
    }

    public InputSource resolveEntity(DocumentTypeDeclaration dtDecl) throws SAXException, IOException {
        return this.resolveEntity(dtDecl.getName(), dtDecl.getPublicId(), null, dtDecl.getSystemId());
    }

    public InputSource resolveEntity(String documentTypeDeclaration) throws SAXException, IOException {
        return this.resolveEntity(DocumentTypeDeclaration.parse(documentTypeDeclaration));
    }

    Reader loadDTDfromClasspath(String dtdFilename) {
        final String resPath = dtdFilename.charAt(0) != '/' ? String.valueOf('/') + DefaultEntityResolver.class.getPackage().getName().replace('.', '/') + '/' + dtdFilename : dtdFilename;
        InputStream is = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                if (DefaultEntityResolver.this.loader != null) {
                    return DefaultEntityResolver.this.loader.getResourceAsStream(resPath);
                }
                return this.getClass().getResourceAsStream(resPath);
            }
        });
        InputStreamReader re = null;
        if (is != null) {
            try {
                re = new InputStreamReader(is, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                re = new InputStreamReader(is);
            }
        }
        return re;
    }
}

