/*

 Copyright (c) 2005-2011, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.dom4j;

import info.informatica.doc.style.css.CSSStyleSheetFactory;
import info.informatica.doc.style.css.dom.BaseCSSStyleSheet;
import info.informatica.doc.style.css.dom.CSSRuleArrayList;
import info.informatica.doc.style.css.dom.ComputedCSSStyle;
import info.informatica.doc.style.css.dom.DOMMediaList;

import java.net.URL;

import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.stylesheets.MediaList;

/**
 * CSS Style Sheet for DOM4J.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 * 
 */
public class DOM4JCSSStyleSheet extends BaseCSSStyleSheet implements Cloneable {

	XHTMLElement ownerElement;

	public DOM4JCSSStyleSheet(CSSStyleSheetFactory factory, XHTMLElement ownerElement, MediaList media,
			CSSRule ownerRule) {
		super(factory, media, ownerRule);
		this.ownerElement = ownerElement;
	}

	public DOM4JCSSStyleSheet(CSSStyleSheetFactory factory, XHTMLElement ownerElement, MediaList media) {
		this(factory, ownerElement, media, null);
	}

	public URL getDocumentBaseURL() {
		return ownerElement.getDocument().getBaseURL();
	}

	public XHTMLElement getDOM4JOwnerElement() {
		return ownerElement;
	}

	/**
	 * Gets the computed style for the given DOM4J element and pseudo-element.
	 * 
	 * @param elm
	 *            the element.
	 * @param pseudoElt
	 *            the pseudo-element.
	 * @return the computed style declaration.
	 */
	public CSSStyleDeclaration getComputedStyle(CSSStylableElement elm,
			String pseudoElt) {
		// Get the inline style
		ComputedCSSStyle inline = (ComputedCSSStyle) elm.getStyle();
		// Compute style
		ComputedCSSStyle style = computeStyle(new DOM4JCSSStyleDeclaration(), 
				elm.getSelectorMatcher(), inline, pseudoElt);
		// We set the element to which the declaration applies
		((DOM4JCSSStyleDeclaration) style).setPeerNode(elm);
		return style;
	}

	/**
	 * Creates and returns a copy of this style sheet.
	 * <p>The copy is a shallow copy (the rule list is new, but the
	 * referenced rules are the same as in the cloned object.
	 * 
	 * @return a clone of this instance.
	 */
	@Override
	public DOM4JCSSStyleSheet clone() {
		DOM4JCSSStyleSheet myClone = new DOM4JCSSStyleSheet(getStyleSheetFactory(), 
				getDOM4JOwnerElement(), (DOMMediaList)getMedia(), getOwnerRule());
		myClone.setTitle(getTitle());
		myClone.currentInsertionIndex = this.currentInsertionIndex;
		myClone.setDisabled(getDisabled());
		myClone.setHref(getHref());
		myClone.setNamespaceURI(getNamespaceURI());
		myClone.setParentStyleSheet(getParentStyleSheet());
		myClone.cssRules = (CSSRuleArrayList) this.cssRules.clone();
		myClone.targetMedium = this.targetMedium;
		return myClone;
	}

}
