/*

 Copyright (c) 2005-2011, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.dom4j;

import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.dom.DOMAttribute;

/**
 * An attribute that fires a document-wide style modify event when changed.
 * 
 * @author Carlos Amengual
 *
 */
class DocumentStyleEventAttribute extends DOMAttribute {

	private static final long serialVersionUID = 1L;

	DocumentStyleEventAttribute(QName qname) {
		super(qname);
	}

	DocumentStyleEventAttribute(QName qname, String value) {
		super(qname, value);
	}

	DocumentStyleEventAttribute(Element parent, QName qname, String value) {
		super(parent, qname, value);
	}

	@Override
	public void setValue(String value) {
		super.setValue(value);
		((XHTMLDocument)getDocument()).onStyleModify();
	}

}
