/*

 Copyright (c) 2005-2011, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.dom4j;

import org.dom4j.Node;
import org.dom4j.QName;

/**
 * XHTML head element.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 * 
 */
class HeadElement extends XHTMLElement {

	private static final long serialVersionUID = 2L;

	HeadElement(String name) {
		super(name);
	}

	HeadElement(QName qname) {
		super(qname);
	}

    HeadElement(QName qname, int attributeCount) {
        super(qname, attributeCount);
    }

	@Override
	protected void childAdded(Node node) {
		super.childAdded(node);
		if(node instanceof StyleDefiner) {
			getDocument().onEmbeddedStyleAdd((StyleDefiner) node);
		} else if(node instanceof BaseURLElement) {
			getDocument().setBaseURL(((BaseURLElement)node).base);
			((BaseURLElement)node).base = null; // help GC in case another URL is set at document
		}
	}

	@Override
	protected void childRemoved(Node node) {
		if(node instanceof StyleDefiner) {
			getDocument().onEmbeddedStyleRemove((StyleDefiner) node);
		}
		super.childRemoved(node);
	}

}
