/*

 Copyright (c) 2005-2011, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.dom4j;

import java.io.Reader;
import java.io.StringReader;

import org.dom4j.Element;
import org.dom4j.QName;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;

/**
 * <code>style</code> element.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 * 
 */
class StyleElement extends XHTMLElement implements StyleDefiner {

	private static final long serialVersionUID = 2L;

	StyleElement(String name) {
		super(name);
	}

	StyleElement(QName qname) {
		super(qname);
	}

    StyleElement(QName qname, int attributeCount) {
        super(qname, attributeCount);
    }

	/**
	 * Adds the style in this element to the document's style sheet.
	 * 
	 * @throws CSSException if could not parse the style sheet.
	 */
	public void mergeStyle() throws CSSException {
		String styleText = getTextTrim();
		if(styleText.length() > 0){
			InputSource source = new InputSource();
			Reader re = new StringReader(styleText);
			source.setCharacterStream(re);
			try {
				getDocument().addStyleSheet(source);
			} catch (CSSException e) {
				throw e;
			} catch (Exception e) {
				throw new CSSException(e);
			}
		}
	}

	@Override
	public Element addText(String text) {
		getDocument().onStyleModify();
		return super.addText(text);
	}

}
