/*

 Copyright (c) 2005-2011, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.pdf.itext;

import info.informatica.doc.agent.UserAgent;
import info.informatica.doc.agent.DownloadListener;
import info.informatica.doc.dom4j.CSSStylableElement;
import info.informatica.doc.dom4j.XHTMLDocument;
import info.informatica.doc.style.css.j2d.ImgReplacedBox;
import info.informatica.doc.style.css.visual.CSSReplacementException;
import info.informatica.doc.style.css.visual.box.AbstractReplacedBox;

import java.io.IOException;

import com.itextpdf.text.BadElementException;
import com.itextpdf.text.Image;

/**
 * PDF Image replaced element box.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 *
 */
public class PDFImgReplacedBox extends AbstractReplacedBox<Image> implements DownloadListener<Image> {
	
	private Image image = null;

	public PDFImgReplacedBox(CSSStylableElement elem) {
		super(elem);
	}

	public void init(UserAgent<Image> agent) throws CSSReplacementException {
		String imgUri = getReplacedElement().attributeValue("src");
		if(imgUri == null || imgUri.length() == 0){
			throw new CSSReplacementException("img element has no src attribute.");
		}
		try {
			agent.addDownloadListener(((XHTMLDocument)getReplacedElement().getDocument()).
					getURL(imgUri), this);
		} catch (IOException e) {
			image = getBrokenImage();
			throw new CSSReplacementException(e);
		}
	}

	public void doContentDownloaded(Image img) {
		image = img;
	}

	public void doFailedDownload() {
		image = getBrokenImage();
	}

	private Image getBrokenImage() {
		try {
			return Image.getInstance(ImgReplacedBox.getBrokenImage(), null);
		} catch (BadElementException e1) {
		} catch (IOException e1) {
		}
		return null;
	}

	public Image getNativeContent() {
		return image;
	}

	public float getIntrinsicHeight() {
		return image.getPlainHeight();
	}

	public float getIntrinsicWidth() {
		return image.getPlainWidth();
	}


}
