/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.structure;

import info.informatica.doc.RenderingException;

/**
 * Interface used to help rendering tables.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 * 
 */
public interface TableRenderer {

	/**
	 * Initialize the table appropriately for printing table headers. Must be
	 * called before printing the first header.
	 * 
	 */
	public void initHeader();

	/**
	 * Print a header cell.
	 * 
	 * @param headerCell
	 *            the cell that must be rendered as a header cell.
	 * @param cellValue
	 *            the text contents of the cell.
	 */
	public void printHeaderCell(TableCell headerCell, String cellValue);

	/**
	 * Start the rendering of a table row.
	 * 
	 * @param row the row box.
	 */
	public void startRow(TableRow row);

	/**
	 * End the rendering of a table row.
	 */
	public void endRow();

	/**
	 * Print a table cell.
	 * 
	 * @param cell
	 *            the table cell that must be rendered.
	 * @param cellValue
	 *            the text contents of the cell.
	 */
	public void printCell(TableCell cell, String cellValue);

	/**
	 * End the rendering of the table.
	 */
	public void endTable() throws RenderingException;

}
