/*

 Copyright (c) 2005-2011, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.dom;

import info.informatica.doc.style.css.CSSStyleSheetFactory;

import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.stylesheets.MediaList;

/**
 * CSS Style Sheet for DOM.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 * 
 */
public class DOMCSSStyleSheet extends BaseCSSStyleSheet implements Cloneable {

	private Node ownerNode = null;

	public DOMCSSStyleSheet(CSSStyleSheetFactory factory, Node ownerNode, MediaList media,
			CSSRule ownerRule) {
		super(factory, media, ownerRule);
		this.ownerNode = ownerNode;
	}

	public DOMCSSStyleSheet(CSSStyleSheetFactory factory, Node ownerNode, MediaList media) {
		this(factory, ownerNode, media, null);
	}

	public Node getOwnerNode() {
		return ownerNode;
	}

	/**
	 * Gets the computed style for the given DOM Element and pseudo-element.
	 * 
	 * @param elm
	 *            the element.
	 * @param pseudoElt
	 *            the pseudo-element.
	 * @return the computed style declaration.
	 */
	public CSSStyleDeclaration getComputedStyle(Element elm, String pseudoElt) {
		DOMCSSStyleDeclaration inline = null;
		String st = elm.getAttribute("style");
		if (st.length() > 0) {
			inline = new DOMCSSStyleDeclaration();
			try {
				inline.setCssText(st);
				inline.setPeerNode(elm);
			} catch (DOMException e) {
				log.error("Could not parse style", e);
				inline = null;
			}
		}
		CSSStyleDeclaration style = computeStyle(new DOMCSSStyleDeclaration(this),
				new DOMSelectorMatcher(elm), inline, pseudoElt);
		return style;
	}

	/**
	 * Creates and returns a copy of this style sheet.
	 * <p>The copy is a shallow copy (the rule list is new, but the
	 * referenced rules are the same as in the cloned object.
	 * 
	 * @return a clone of this instance.
	 */
	@Override
	public DOMCSSStyleSheet clone() {
		DOMCSSStyleSheet myClone = new DOMCSSStyleSheet(getStyleSheetFactory(), 
				getOwnerNode(), (DOMMediaList)getMedia(), getOwnerRule());
		myClone.setTitle(getTitle());
		myClone.currentInsertionIndex = this.currentInsertionIndex;
		myClone.setDisabled(getDisabled());
		myClone.setHref(getHref());
		myClone.setNamespaceURI(getNamespaceURI());
		myClone.setParentStyleSheet(getParentStyleSheet());
		myClone.cssRules = (CSSRuleArrayList) this.cssRules.clone();
		myClone.targetMedium = this.targetMedium;
		return myClone;
	}

}
