/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.dom;

import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.CSSUnknownRule;

/**
 * Implementation of CSSUnknownRule.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 * 
 */
public class DOMCSSUnknownRule extends BaseCSSRule implements CSSUnknownRule {
	private String cssText = null;

	public DOMCSSUnknownRule(CSSStyleSheet parentSheet) {
		super(parentSheet, CSSRule.UNKNOWN_RULE);
	}

	@Override
	public void setCssText(String cssText) throws DOMException {
		this.cssText = cssText;
	}

	@Override
	public String getCssText() {
		return cssText;
	}
}
