/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.dom;

import org.w3c.dom.Node;


/**
 * CSS Selector matcher for DOM.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 * 
 */
class DOMSelectorMatcher extends SelectorMatcher {

	private String idAttr = null;

	org.w3c.dom.Element element;

	public DOMSelectorMatcher(org.w3c.dom.Element elm) {
		super();
		element = elm;
		setTagname(elm.getTagName().intern());
		org.w3c.dom.Node parent = elm.getParentNode();
		if (parent != null) {
			setParentTagname(parent.getLocalName().intern());
		}
		setClassAttribute(elm.getAttribute("class"));
		idAttr = elm.getAttribute("id");
	}

	@Override
	public SelectorMatcher getParentSelectorMatcher() {
		Node parent = element.getParentNode();
		if(parent instanceof org.w3c.dom.Element) {
			// This should be always true if the tree is built correctly
			return new DOMSelectorMatcher((org.w3c.dom.Element)parent);
		} else {
			return null;
		}
	}

	@Override
	public SelectorMatcher getPreviousSiblingSelectorMatcher() {
		Node sibling = element.getPreviousSibling();
		if(sibling instanceof org.w3c.dom.Element) {
			return new DOMSelectorMatcher((org.w3c.dom.Element)sibling);
		} else {
			return null;
		}
	}

	@Override
	public boolean isFirstChild() {
		return element.getPreviousSibling() == null;
	}

	@Override
	public String getAttributeValue(String attrName) {
		return element.getAttribute(attrName);
	}

	public boolean hasAttribute(String attrName) {
		return element.hasAttribute(attrName);
	}

	@Override
	public String getLanguage() {
		/*
		 *  FIXME: In (X)HTML, the lang attribute contains the language,
		 *  but that may not be true for other XML.
		 */
		String lang = element.getAttribute("lang");
		while(lang.length() == 0) {
			Node parent = element.getParentNode();
			if(parent instanceof org.w3c.dom.Element) {
				break;
			} else {
				lang = ((org.w3c.dom.Element)parent).getAttribute("lang");
			}
		}
		if(lang.length() == 0) {
			lang = null;
		}
		return lang;
	}

	@Override
	public String getId() {
		return idAttr;
	}

}
