/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.j2d;

/**
 * CSS style database for headless devices.
 * <p>
 * Useful for testing.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 * 
 */
public class HeadlessStyleDatabase extends Java2DStyleDatabase {
	
	public HeadlessStyleDatabase() {
		super();
	}

	protected float deviceResolutionFactor() {
		return 1f;
	}

	@Override
	protected float cmToPixels(float cm) {
		// XXX
		double width = 1024;
		double height = 768;
		double diag = Math.sqrt(width * width + height * height);
		// Assume a screen of 17" = 43cm
		return (float) (cm * diag / 43.18);
	}

	@Override
	protected float pxTocm(int px) {
		// XXX
		double width = 1024;
		double height = 768;
		double diag = Math.sqrt(width * width + height * height);
		// Assume a screen of 17" = 43cm
		return (float) (px * 43.18 / diag);
	}

	@Override
	public float getDocumentHeight() {
		return 768f;
	}

	@Override
	public float getDocumentWidth() {
		return 1024f;
	}

}
