/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.j2d;

import info.informatica.doc.agent.DownloadListener;
import info.informatica.doc.agent.UserAgent;
import info.informatica.doc.dom4j.CSSStylableElement;
import info.informatica.doc.style.css.visual.CSSReplacementException;
import info.informatica.doc.style.css.visual.box.AbstractReplacedBox;

import java.awt.image.BufferedImage;
import java.io.IOException;

/**
 * Image replaced element box.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 *
 */
public class ImgReplacedBox extends AbstractReplacedBox<BufferedImage> implements DownloadListener<BufferedImage> {
	
	private BufferedImage image = null;

	public ImgReplacedBox(CSSStylableElement elem) {
		super(elem);
	}

	public void init(UserAgent<BufferedImage> agent) throws CSSReplacementException {
		String imgUri = getReplacedElement().attributeValue("src");
		if(imgUri == null || imgUri.length() == 0){
			throw new CSSReplacementException("img element has no src attribute.");
		}
		try {
			agent.addDownloadListener(getReplacedElement().getDocument().
					getURL(imgUri), this);
		} catch (IOException e) {
			image = getBrokenImage();
			throw new CSSReplacementException(e);
		}
	}

	public void doContentDownloaded(BufferedImage img) {
		image = img;
	}

	public void doFailedDownload() {
		image = getBrokenImage();
	}

	public BufferedImage getNativeContent() {
		return image;
	}

	public float getIntrinsicWidth() {
		BufferedImage img = getNativeContent();
		if(img == null){
			return 300f;
		} else {
			return (float)img.getWidth();
		}
	}

	public float getIntrinsicHeight() {
		BufferedImage img = getNativeContent();
		if(img == null){
			return 200f;
		} else {
			return (float)img.getHeight();
		}
	}

	public static BufferedImage getBrokenImage() {
		return null;
	}

}
