/*

 Copyright (c) 2005-2011, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.j2d;

import info.informatica.doc.agent.ResourceDownloader;
import info.informatica.doc.dom4j.DOM4JUserAgent;
import info.informatica.doc.style.css.StyleDatabase;
import info.informatica.doc.style.css.visual.ElementReplacer;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import javax.imageio.ImageIO;

/**
 * User Agent for Java2D.
 * <p>
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 */
public class Java2DUserAgent extends DOM4JUserAgent<BufferedImage> {
	
	private StyleDatabase styleDb = new Java2DStyleDatabase();

	public Java2DUserAgent() {
		super();
		setElementReplacer(ElementReplacer.NAMESPACE_XHTML, 
				new Java2DXHTMLElementReplacer());
	}

	@Override
	public StyleDatabase getStyleDatabase() {
		return styleDb;
	}
	
	public void setStyleDatabase(StyleDatabase styleDb) {
		this.styleDb = styleDb;
	}

	public ResourceDownloader<BufferedImage> createDownloader(URL url) {
		return new AWTImageDownloader(url);
	}

	/**
	 * Asynchronous downloading of images.
	 * 
	 * @author Carlos Amengual
	 *
	 */
	class AWTImageDownloader extends ResourceDownloader<BufferedImage> {
		
		public AWTImageDownloader(URL url) {
			super(url);
		}

		protected void readContent(InputStream is) throws IOException {
			nativeContent = ImageIO.read(is);
		}
	
	}

}