/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.property;

import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSValue;

/**
 * An inherited value.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 *
 */
public class CSSInheritedValue extends AbstractCSSValue {
	private static CSSValue singleton = new CSSInheritedValue();

	/**
	 * Must access instance through static method.
	 *
	 */
	protected CSSInheritedValue() {
		super(CSSValue.CSS_INHERIT);
	}
	
	public static CSSValue getValue() {
		return singleton;
	}

	@Override
	public void setCssText(String cssText) throws DOMException {
		throw new DOMException(DOMException.INVALID_MODIFICATION_ERR, "Attempt to modify inherited value");
	}

}
