/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.property;

import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.Counter;

/**
 * CSS primitive value returning a Counter.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 *
 */
public class DOMCSSCounterValue extends AbstractCSSPrimitiveValue {
	
	private Counter counter = null;

	public DOMCSSCounterValue() {
		super(CSSPrimitiveValue.CSS_COUNTER);
	}

	@Override
	public Counter getCounterValue() throws DOMException {
		return counter;
	}

	@Override
	void setLexicalUnit(LexicalUnit lunit) {
		super.setLexicalUnit(lunit);
		counter = new CSSCounter(lunit);
	}

	/**
	 * Implementation of <code>Counter</code>.
	 * 
	 * @author Carlos Amengual (amengual at informatica.info)
	 *
	 */
	public class CSSCounter implements Counter {
		
		private String identifier = null;
		private String listStyle = null;
		private String separator = null;
		
		public CSSCounter(LexicalUnit lunit) {
			super();
			LexicalUnit lu = lunit.getParameters();
			identifier = lu.getStringValue();
			lu = lu.getNextLexicalUnit();
			if(lu != null){
				lu = lu.getNextLexicalUnit();
				listStyle = lu.getStringValue();
			}
			lu = lunit.getNextLexicalUnit();
			if(lu != null){
				separator = lu.getStringValue();
			}
		}

		public String getIdentifier() {
			return identifier;
		}
	
		public String getListStyle() {
			return listStyle;
		}
	
		public String getSeparator() {
			return separator;
		}
	}
}
