/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.visual;

import info.informatica.doc.style.css.CSS2ComputedProperties;
import info.informatica.doc.style.css.CSSErrorHandler;

import org.w3c.dom.css.CSSPrimitiveValue;


/**
 * CSS box.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 *
 */
public interface CSSBox {

	/**
	 * Gets the computed style for the element that generated this box.
	 * 
	 * @return the computed style.
	 */
	public CSS2ComputedProperties getComputedStyle();

	/**
	 * Sets the CSS error handler.
	 * 
	 * @param errorHandler the error handler.
	 */
	public void setErrorHandler(CSSErrorHandler errorHandler);

	/**
	 * Gets the 'containing block' for thid box, as defined by the 
	 * CSS specification.
	 * 
	 * @return the block box corresponding to the 'containing block', 
	 * or null if it is the topmost box.
	 */
	public CSSContainerBox getContainingBlock();

	/**
	 * Gets the box generated by the element that generated 
	 * this box.
	 * 
	 * @return the next box generated by the element, or null if 
	 * this box does not generate content.
	 */
	public CSSBox getGeneratedSibling();

	public float getLeft();
	
	public float getRight();

	public CSSPrimitiveValue getBorderTopColor();

	public CSSPrimitiveValue getBorderRightColor();

	public CSSPrimitiveValue getBorderBottomColor();

	public CSSPrimitiveValue getBorderLeftColor();

	public float getBorderTopWidth();

	public float getBorderRightWidth();

	public float getBorderBottomWidth();

	public float getBorderLeftWidth();

	/**
	 * Gets the value of the margin-top property, expressed in the 
	 * unit given by the <code>StyleDatabase.getNaturalUnit()</code> method.
	 * 
	 * @return  the value of the margin-top property.
	 */
	public float getMarginTop();

	/**
	 * Gets the value of the margin-bottom property, expressed in the 
	 * unit given by the <code>StyleDatabase.getNaturalUnit()</code> method.
	 * 
	 * @return  the value of the margin-bottom property.
	 */
	public float getMarginBottom();

	/**
	 * Gets the value of the margin-right property, expressed in the 
	 * unit given by the <code>StyleDatabase.getNaturalUnit()</code> method.
	 * 
	 * @return  the value of the margin-right property.
	 */
	public float getMarginRight();

	/**
	 * Gets the value of the margin-left property, expressed in the 
	 * unit given by the <code>StyleDatabase.getNaturalUnit()</code> method.
	 * 
	 * @return  the value of the margin-left property.
	 */
	public float getMarginLeft();

	/**
	 * Gets the value of the padding-top property, expressed in the 
	 * unit given by the <code>StyleDatabase.getNaturalUnit()</code> method.
	 * 
	 * @return the value of the padding-top property.
	 */
	public float getPaddingTop();

	/**
	 * Gets the value of the padding-right property, expressed in the 
	 * unit given by the <code>StyleDatabase.getNaturalUnit()</code> method.
	 * 
	 * @return the value of the padding-right property.
	 */
	public float getPaddingRight();

	/**
	 * Gets the value of the padding-bottom property, expressed in the 
	 * unit given by the <code>StyleDatabase.getNaturalUnit()</code> method.
	 * 
	 * @return the value of the padding-bottom property.
	 */
	public float getPaddingBottom();

	/**
	 * Gets the value of the padding-left property, expressed in the 
	 * unit given by the <code>StyleDatabase.getNaturalUnit()</code> method.
	 * 
	 * @return the value of the padding-left property.
	 */
	public float getPaddingLeft();

	/**
	 * Gets the position for the background image, if any.
	 * 
	 * @return the position for the background image.
	 */
	public CSSPoint getBackgroundPosition();

}