/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.visual;

import info.informatica.doc.style.css.visual.container.CSSBoxContainer;


/**
 * A box that acts as a container for other boxes.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 *
 */
public interface CSSContainerBox extends CSSBox {
	
	public void setBoxContainer(CSSBoxContainer container);

	/**
	 * Retrieve the box container object.
	 * 
	 * @return the box container with the child boxes.
	 */
	public CSSBoxContainer asContainerBox();

	/**
	 * Gets the computed width of this box, expressed in the 
	 * unit given by the <code>StyleDatabase.getNaturalUnit()</code> method.
	 * 
	 * @return the width of this box.
	 */
	public float getWidth();
	
	/**
	 * Gets the computed height of this box, expressed in the 
	 * unit given by the <code>StyleDatabase.getNaturalUnit()</code> method.
	 * 
	 * @return the height of this box.
	 */
	public float getHeight();

}